/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.consumer;

import com.dap.component.rocketmq.DWRocketMQException;
import com.dap.component.rocketmq.api.consumer.DWRocketMQConsumerInterceptor;
import com.dap.component.rocketmq.api.consumer.DWRocketMQConsumerMessageListener;
import com.dap.component.rocketmq.api.properties.DWRocketMQConsumerProperties;
import com.dap.component.rocketmq.consumer.DWRocketMQConsumerDefaultMessageListener;
import com.dap.component.rocketmq.consumer.DWRocketMQConsumerHolder;
import com.dap.component.rocketmq.consumer.annotation.DWRocketMQConsumeListener;
import com.dap.component.rocketmq.enums.SelectorType;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.FilterExpressionType;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DWRocketMQConsumeListenerProcessor {
    private ApplicationContext applicationContext;
    private DWRocketMQConsumerHolder consumerHolder;
    private DWRocketMQConsumerProperties consumerProperties;

    public DWRocketMQConsumeListenerProcessor(ApplicationContext applicationContext, DWRocketMQConsumerHolder consumerHolder, DWRocketMQConsumerProperties consumerProperties) {
        this.consumerHolder = consumerHolder;
        this.consumerProperties = consumerProperties;
        this.applicationContext = applicationContext;
    }

    public void processConsumeListener(DWRocketMQConsumeListener consumeListener, Method method, Object bean) {
        this.checkNull(consumeListener, this.consumerProperties.getEndpoints());
        Method invocableMethod = AopUtils.selectInvocableMethod((Method)method, bean.getClass());
        Class<?> parameterTypeClazz = this.getParameterTypeClazz(invocableMethod);
        List<DWRocketMQConsumerInterceptor> interceptors = this.getConsumerInterceptors();
        DWRocketMQConsumerDefaultMessageListener messageListener = new DWRocketMQConsumerDefaultMessageListener(bean, parameterTypeClazz, invocableMethod, interceptors, consumeListener.topicName());
        PushConsumer pushConsumer = null;
        try {
            FilterExpression filterExpression = this.createFilterExpression(consumeListener.selectorType(), consumeListener.selectorExpress());
            pushConsumer = this.buildConsumer(consumeListener.topicName(), consumeListener.consumerGroup(), filterExpression, messageListener);
        }
        catch (Exception e) {
            throw new DWRocketMQException(e);
        }
        String consumerName = this.generateConsumerName(consumeListener.consumerGroup(), bean.getClass().getName(), method.getName());
        this.consumerHolder.putConsumer(consumerName, pushConsumer);
    }

    private PushConsumer buildConsumer(String topic, String consumerGroup, FilterExpression filterExpression, DWRocketMQConsumerMessageListener messageListener) throws ClientException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        ClientConfiguration clientConfiguration = ClientConfiguration.newBuilder().setCredentialProvider((SessionCredentialsProvider)new StaticSessionCredentialsProvider(this.consumerProperties.getAccessKey(), this.consumerProperties.getSecretKey())).setEndpoints(this.consumerProperties.getEndpoints()).enableSsl(this.consumerProperties.getSslEnabled().booleanValue()).setRequestTimeout(Duration.ofMillis(this.consumerProperties.getConsumeRequestTimeout().intValue())).build();
        return provider.newPushConsumerBuilder().setConsumerGroup(consumerGroup).setClientConfiguration(clientConfiguration).setConsumptionThreadCount(this.consumerProperties.getConsumeThreadNum().intValue()).setMaxCacheMessageCount(this.consumerProperties.getMaxCacheMsgNum().intValue()).setMaxCacheMessageSizeInBytes(this.consumerProperties.getMaxCacheMsgSize().intValue()).setSubscriptionExpressions(Collections.singletonMap(topic, filterExpression)).setMessageListener((MessageListener)messageListener).build();
    }

    private Class<?> getParameterTypeClazz(Method invocableMethod) {
        Object[] parameterTypes = invocableMethod.getParameterTypes();
        if (ObjectUtils.isEmpty((Object[])parameterTypes) || parameterTypes.length != 1) {
            throw new DWRocketMQException("The method parameter type is invalid.");
        }
        return parameterTypes[0];
    }

    private List<DWRocketMQConsumerInterceptor> getConsumerInterceptors() {
        Map beanMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, DWRocketMQConsumerInterceptor.class);
        if (!CollectionUtils.isEmpty((Map)beanMap)) {
            return new ArrayList<DWRocketMQConsumerInterceptor>(beanMap.values());
        }
        return null;
    }

    private FilterExpression createFilterExpression(SelectorType selectorType, String selectorExpress) {
        FilterExpression filterExpression = new FilterExpression();
        if (Objects.nonNull((Object)selectorType) && StringUtils.hasText((String)selectorExpress)) {
            filterExpression = new FilterExpression(selectorExpress, selectorType == SelectorType.TAG ? FilterExpressionType.TAG : FilterExpressionType.SQL92);
        } else if (StringUtils.hasText((String)selectorExpress)) {
            filterExpression = new FilterExpression(selectorExpress, FilterExpressionType.TAG);
        }
        return filterExpression;
    }

    private String generateConsumerName(String consumerGroup, String clazzName, String methodName) {
        return String.join((CharSequence)".", consumerGroup, clazzName, methodName);
    }

    private void checkNull(DWRocketMQConsumeListener consumeListener, String endpoints) {
        String errMsg = "";
        if (!StringUtils.hasText((String)endpoints)) {
            errMsg = "The 'endpoint' of rocketmq is empty.";
        } else if (!StringUtils.hasText((String)consumeListener.topicName())) {
            errMsg = "The consumer 'topicName' of rocketmq is empty.";
        } else if (!StringUtils.hasText((String)consumeListener.consumerGroup())) {
            errMsg = "The consumer 'consumerGroup' of rocketmq is empty.";
        } else if (Objects.isNull((Object)consumeListener.selectorType())) {
            errMsg = "The consumer 'selectorType' of rocketmq is empty.";
        }
        if (StringUtils.hasText((String)errMsg)) {
            throw new DWRocketMQException(errMsg);
        }
    }
}

