/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.util;

import org.apache.commons.logging.Log;

public final class DWScheduleExceptionUtils {
    private DWScheduleExceptionUtils() {
    }

    public static void log(Log log, String classTag, Exception exception) {
        log.error((Object)(classTag + " Exception : " + exception));
        log.error((Object)(classTag + " Exception Message : " + exception.getMessage()));
        log.error((Object)(classTag + " Exception Stack Trace : " + DWScheduleExceptionUtils.getStackTrace(exception)));
    }

    public static String getStackTrace(Throwable exception) {
        StringBuilder stackTraceBuilder = new StringBuilder();
        stackTraceBuilder.append(exception.toString()).append("\n");
        for (StackTraceElement element : exception.getStackTrace()) {
            stackTraceBuilder.append("\tat ").append(element).append("\n");
        }
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            stackTraceBuilder.append("Caused by: ").append(cause.toString()).append("\n");
            for (StackTraceElement element : cause.getStackTrace()) {
                stackTraceBuilder.append("\tat ").append(element).append("\n");
            }
        }
        return stackTraceBuilder.toString();
    }
}

