/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.util;

import com.digiwin.app.schedule.DWDistributedScheduleProperties;
import com.digiwin.app.schedule.DWScheduleProperties;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class DWScheduleHttpClient {
    private static CloseableHttpClient httpClient;

    private static void init() {
        DWDistributedScheduleProperties properties = DWScheduleProperties.getDefaultProperties().getDistributedScheduleProperties();
        int maxTotal = properties.getHttpClientConnectionMaxTotal();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(maxTotal);
        connectionManager.setDefaultMaxPerRoute(maxTotal);
        int connectionRequestTimeout = properties.getHttpClientConnectionRequestTimeout();
        int cnnectTimeout = properties.getHttpClientConnectionTimeout();
        int socketTimeout = properties.getHttpClientConnectionSocketTimeout();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout * 1000).setConnectTimeout(cnnectTimeout * 1000).setSocketTimeout(socketTimeout * 1000).build();
        final int maxRetries = properties.getHttpClientMaxRetries();
        ServiceUnavailableRetryStrategy retryStrategy = new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                return executionCount <= maxRetries && response.getStatusLine().getStatusCode() >= 500;
            }

            public long getRetryInterval() {
                return 1000L;
            }
        };
        httpClient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).setServiceUnavailableRetryStrategy(retryStrategy).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
        IdleConnectionMonitorThread monitorThread = new IdleConnectionMonitorThread(connectionManager);
        monitorThread.start();
    }

    public static CloseableHttpClient get() {
        return httpClient;
    }

    static {
        DWScheduleHttpClient.init();
    }

    private static class IdleConnectionMonitorThread
    extends Thread {
        private final PoolingHttpClientConnectionManager connectionManager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(PoolingHttpClientConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connectionManager.closeExpiredConnections();
                        this.connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

