/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.quartz.utils.ConnectionProvider;

public class DWQuartzPoolingConnectionProvider
implements ConnectionProvider {
    private String driver;
    private String url;
    private String user;
    private String password;
    private int minPoolSize;
    private int maxPoolSize;
    private int acquireIncrement;
    private boolean testConnectionOnCheckin;
    private boolean testConnectionOnCheckout;
    private int idleConnectionTestPeriod;
    private int maxIdleTimeExcessConnections;
    private String preferredTestQuery;
    private ComboPooledDataSource datasource;

    public ComboPooledDataSource getDataSource() {
        return this.datasource;
    }

    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    public void shutdown() throws SQLException {
        this.datasource.close();
    }

    public void initialize() throws SQLException {
        if (this.url == null) {
            throw new SQLException("DBPool could not be created: DB URL cannot be null");
        }
        if (this.driver == null) {
            throw new SQLException("DBPool '" + this.url + "' could not be created: " + "DB driver class name cannot be null!");
        }
        if (this.maxPoolSize < 0) {
            throw new SQLException("DBPool '" + this.url + "' could not be created: " + "Max connections must be greater than zero!");
        }
        this.datasource = new ComboPooledDataSource();
        try {
            this.datasource.setDriverClass(this.driver);
        }
        catch (Exception e) {
            throw new SQLException("Problem setting driver class name on datasource: " + e.getMessage(), e);
        }
        this.datasource.setJdbcUrl(this.url);
        this.datasource.setUser(this.user);
        this.datasource.setPassword(this.password);
        this.datasource.setMinPoolSize(this.minPoolSize);
        this.datasource.setMaxPoolSize(this.maxPoolSize);
        this.datasource.setAcquireIncrement(this.acquireIncrement);
        this.datasource.setTestConnectionOnCheckin(this.testConnectionOnCheckin);
        this.datasource.setTestConnectionOnCheckout(this.testConnectionOnCheckout);
        this.datasource.setIdleConnectionTestPeriod(this.idleConnectionTestPeriod);
        this.datasource.setMaxIdleTimeExcessConnections(this.maxIdleTimeExcessConnections);
        this.datasource.setPreferredTestQuery(this.preferredTestQuery);
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setAcquireIncrement(int acquireIncrement) {
        this.acquireIncrement = acquireIncrement;
    }

    public void setTestConnectionOnCheckin(boolean testConnectionOnCheckin) {
        this.testConnectionOnCheckin = testConnectionOnCheckin;
    }

    public void setTestConnectionOnCheckout(boolean testConnectionOnCheckout) {
        this.testConnectionOnCheckout = testConnectionOnCheckout;
    }

    public void setIdleConnectionTestPeriod(int idleConnectionTestPeriod) {
        this.idleConnectionTestPeriod = idleConnectionTestPeriod;
    }

    public void setMaxIdleTimeExcessConnections(int maxIdleTimeExcessConnections) {
        this.maxIdleTimeExcessConnections = maxIdleTimeExcessConnections;
    }

    public void setPreferredTestQuery(String preferredTestQuery) {
        this.preferredTestQuery = preferredTestQuery;
    }
}

