/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.dbservice;

import com.dap.component.schedule.api.ScheduleConfigProvider;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.module.spring.SpringContextUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DWScheduleRecordDBService {
    @Autowired
    private DWDao dao;
    private static String tenantSqlTag;
    private final String querySQL = "select * from dw_schedule_record";
    private final String updateStatusSQL = "update dw_schedule_record set execute_state = ? where execute_id = ? " + tenantSqlTag;
    private final String updateTimeSQL = "update dw_schedule_record set end_time = ? ,execute_state = ?  where execute_id = ? " + tenantSqlTag;
    private final String deleteSQL = "delete from dw_schedule_record where execute_id = ? " + tenantSqlTag;
    private static DWScheduleRecordDBService instance;

    public static DWScheduleRecordDBService getInstance() {
        if (instance == null && SpringContextUtils.containsBean((String)"DWScheduleRecordDBService")) {
            instance = (DWScheduleRecordDBService)SpringContextUtils.getBean((String)"DWScheduleRecordDBService");
            ScheduleConfigProvider configProvider = (ScheduleConfigProvider)SpringContextUtils.getBean((String)"scheduleConfigProvider");
            String tenantTagByColumnName = configProvider.getTenantTagByColumnName();
            tenantSqlTag = tenantTagByColumnName;
        }
        return instance;
    }

    public static void setInstance(DWScheduleRecordDBService instance) {
        DWScheduleRecordDBService.instance = instance;
    }

    public Object updateByDataSet(DWDataSet dataSet) throws Exception {
        return this.dao.execute(dataSet);
    }

    public Object getResultList(DWPagableQueryInfo queryInfo) throws Exception {
        return this.dao.selectWithPage(queryInfo, "select * from dw_schedule_record");
    }

    public Object getResult(DWPagableQueryInfo queryInfo) throws Exception {
        return this.dao.selectWithPage(queryInfo, "select * from dw_schedule_record");
    }

    public int updateStatus(String id, String status) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.updateStatusSQL, new Object[]{status, id});
    }

    public int updateStatusAndEndTime(String id, String status, Object time) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.updateTimeSQL, new Object[]{time, status, id});
    }

    public int delete(String id) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.deleteSQL, new Object[]{id});
    }

    static {
        instance = null;
    }
}

