/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.dbservice;

import com.dap.component.schedule.api.ScheduleConfigProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.DWDistributedScheduleProperties;
import com.digiwin.app.schedule.DWDistributedScheduleWorkersProperties;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DWScheduleDistributeWorkerConfigService {
    @Autowired
    @Qualifier(value="dw-distributed-schedule-properties")
    DWDistributedScheduleProperties distributedScheduleProperties;
    private static DWScheduleDistributeWorkerConfigService instance = null;
    private DWDistributedScheduleWorkersProperties workersProperties;

    public static DWScheduleDistributeWorkerConfigService getInstance() {
        if (instance == null && SpringContextUtils.containsBean((String)"DWScheduleDistributeWorkerConfigService")) {
            instance = (DWScheduleDistributeWorkerConfigService)SpringContextUtils.getBean((String)"DWScheduleDistributeWorkerConfigService");
        }
        return instance;
    }

    public static void setInstance(DWScheduleDistributeWorkerConfigService instance) {
        DWScheduleDistributeWorkerConfigService.instance = instance;
    }

    public synchronized Object getWorkerConfig() {
        DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties workersProperties = new DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties();
        if (this.workersProperties != null && !CollectionUtils.isEmpty(this.workersProperties.getWorker())) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String ip = request.getLocalAddr();
            Map onlineWorkers = DistributedScheduleUtils.onlineWorkers;
            Optional<DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties> workersPropertiesOptional = this.workersProperties.getWorker().stream().filter(item -> !onlineWorkers.keySet().contains("DWQuartz::worker::" + item.getWorkName())).findFirst();
            if (workersPropertiesOptional.isPresent()) {
                workersProperties = workersPropertiesOptional.get();
                String workerId = "DWQuartz::worker::" + workersProperties.getWorkName();
                ScheduleConfigProvider configProvider = (ScheduleConfigProvider)SpringContextUtils.getBean((String)"scheduleConfigProvider");
                long keyExpireTime = configProvider.getDistributedScheduleWorkerTimeout("30");
                String workerUrl = workersProperties.getWorkName() + "::" + ip + ":" + this.distributedScheduleProperties.getDistributedScheduleWorkerServerPort();
                onlineWorkers.put(workerId, workerUrl);
                DWQuartz.redisTemplate.opsForValue().set((Object)workerId, (Object)workerUrl, keyExpireTime, TimeUnit.SECONDS);
            }
        }
        return workersProperties;
    }

    public DWDistributedScheduleWorkersProperties getWorkersProperties() {
        return this.workersProperties;
    }

    public void setWorkersProperties(DWDistributedScheduleWorkersProperties workersProperties) {
        this.workersProperties = workersProperties;
    }
}

