/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.listener;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.schedule.quartz.listener.WorkerKeyExpirationListener;
import com.digiwin.app.schedule.util.DWScheduleWording;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

public class WorkerOnlineReceiver {
    Logger log = LoggerFactory.getLogger(WorkerOnlineReceiver.class);

    public synchronized void receiveMessage(String message) throws Exception {
        message = message.substring(1, message.lastIndexOf("\""));
        if (!DistributedScheduleUtils.isHigherMaster() && ("DWQuartz::worker::" + DistributedScheduleUtils.workerProperties.getWorkName()).equals(message)) {
            this.log.info(message + " worker is online!!");
            DWQuartz.redisTemplate.keys((Object)"DWQuartz::worker::*").forEach(item -> DistributedScheduleUtils.onlineWorkers.put(item, DWQuartz.redisTemplate.opsForValue().get(item)));
        } else {
            this.log.info(message + " worker is online!!");
            RedisMessageListenerContainer dwDistributedScheduleRedisContainer = (RedisMessageListenerContainer)SpringContextUtils.getBean((String)"dwDistributedScheduleRedisContainer");
            WorkerKeyExpirationListener workerKeyExpirationListener = (WorkerKeyExpirationListener)SpringContextUtils.getBean((String)"workerKeyExpirationListener");
            dwDistributedScheduleRedisContainer.removeMessageListener((MessageListener)workerKeyExpirationListener, (Topic)new PatternTopic(DWScheduleWording.REDIS_KEYSPACE + message));
            dwDistributedScheduleRedisContainer.addMessageListener((MessageListener)workerKeyExpirationListener, (Topic)new PatternTopic(DWScheduleWording.REDIS_KEYSPACE + message));
            DistributedScheduleUtils.onlineWorkers.put(message, DWQuartz.redisTemplate.opsForValue().get((Object)message));
        }
    }
}

