/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.alibaba.fastjson.JSON;
import com.dap.component.schedule.api.ScheduleConfigProvider;
import com.digiwin.app.autoconfigure.DWDaoAutoConfiguration;
import com.digiwin.app.autoconfigure.condition.DWDistributeScheduleCondition;
import com.digiwin.app.autoconfigure.condition.DWLeaderElectionScheduleCondition;
import com.digiwin.app.autoconfigure.condition.DWScheduleEnableCondition;
import com.digiwin.app.dao.properties.DWDaoDataSourceProperties;
import com.digiwin.app.dao.security.AESUtil;
import com.digiwin.app.schedule.DWDistributedScheduleProperties;
import com.digiwin.app.schedule.DWDistributedScheduleWorkersProperties;
import com.digiwin.app.schedule.DWQuartzProperties;
import com.digiwin.app.schedule.DWScheduleProperties;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.schedule.dbservice.DWScheduleContactDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleDistributeWorkerConfigService;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleTimeDBService;
import com.digiwin.app.schedule.leaderelection.LeaderElectionScheduler;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.schedule.quartz.listener.WorkerKeyExpirationListener;
import com.digiwin.app.schedule.quartz.listener.WorkerOnlineReceiver;
import com.digiwin.app.schedule.util.DWScheduleWording;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.google.gson.Gson;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
@DependsOn(value={"scheduleConfigProvider", "scheduleRequestContextProvider", "scheduleServiceProvider", "scheduleThrowDWExceptionProvider", "dw-spring-context-utils", "dw-json-config"})
@AutoConfigureBefore(value={DWDaoAutoConfiguration.class})
public class DWScheduleAutoConfiguration {
    private static final String KEY_FALSE = "false";
    private static Log log = LogFactory.getLog(DWScheduleAutoConfiguration.class);

    @Bean(value={"dw-distributed-schedule-properties"})
    public DWDistributedScheduleProperties distributedScheduleProperties(Environment environment) {
        DWDistributedScheduleProperties distributedScheduleProperties = new DWDistributedScheduleProperties();
        distributedScheduleProperties.setEnabled(Boolean.parseBoolean(environment.getProperty("distributedScheduleEnable", KEY_FALSE)));
        distributedScheduleProperties.setTargetJobAppUrl(environment.getProperty("distributedScheduleTargetUrl"));
        distributedScheduleProperties.setSimpleMaster(Boolean.parseBoolean(environment.getProperty("distributedScheduleSimpleMaster", KEY_FALSE)));
        distributedScheduleProperties.setHigherMaster(Boolean.parseBoolean(environment.getProperty("distributedScheduleHigherMaster", KEY_FALSE)));
        distributedScheduleProperties.setMasterUrl(environment.getProperty("distributedScheduleMasterUrl"));
        distributedScheduleProperties.setWorker(Boolean.parseBoolean(environment.getProperty("distributedScheduleWorker", KEY_FALSE)));
        distributedScheduleProperties.setWorkerUrl(environment.getProperty("distributedScheduleWorkerUrl"));
        distributedScheduleProperties.setDistributedScheduleWorkerTimeout(Integer.parseInt(environment.getProperty("distributedScheduleWorkerTimeout", "300")));
        distributedScheduleProperties.setDistributedScheduleWorkerHeartbeatInterval(Integer.parseInt(environment.getProperty("distributedScheduleWorkerHeartbeatInterval", "30")));
        distributedScheduleProperties.setDistributedScheduleWorkerReconnectInterval(Integer.parseInt(environment.getProperty("distributedScheduleWorkerReconnectInterval", "60")));
        distributedScheduleProperties.setHttpClientConnectionMaxTotal(Integer.parseInt(environment.getProperty("distributedScheduleHttpClientMaxTotal", "1500")));
        distributedScheduleProperties.setHttpClientConnectionRequestTimeout(Integer.parseInt(environment.getProperty("distributedScheduleConnectRequestTimeout", "30")));
        distributedScheduleProperties.setHttpClientConnectionTimeout(Integer.parseInt(environment.getProperty("distributedScheduleConnectTimeout", "30")));
        distributedScheduleProperties.setHttpClientConnectionSocketTimeout(Integer.parseInt(environment.getProperty("distributedScheduleSocketTimeout", "30")));
        distributedScheduleProperties.setHttpClientMaxRetries(Integer.parseInt(environment.getProperty("distributedScheduleMaxRetries", "3")));
        distributedScheduleProperties.setScheduleRetryTimes(Integer.parseInt(environment.getProperty("scheduleRetryTimes", "0")));
        distributedScheduleProperties.setScheduleRetrySleepSeconds(Integer.parseInt(environment.getProperty("scheduleRetrySleepSeconds", "60")));
        return distributedScheduleProperties;
    }

    @Bean(value={"dw-schedule-properties"})
    public DWScheduleProperties scheduleProperties(Environment environment, DWDistributedScheduleProperties distributedScheduleProperties) {
        DWScheduleProperties scheduleProperties = new DWScheduleProperties();
        scheduleProperties.setDistributedScheduleProperties(distributedScheduleProperties);
        DWScheduleProperties.setDefaultProperties((DWScheduleProperties)scheduleProperties);
        scheduleProperties.setEnabled(DWScheduleEnableCondition.isScheduleEnabled((Environment)environment));
        if (scheduleProperties.isEnabled()) {
            scheduleProperties.setRemoteInvocation("true".equalsIgnoreCase(environment.getProperty("scheduleRemoteInvocation", KEY_FALSE)));
            scheduleProperties.setEmailSMTPHost(environment.getProperty("scheduleEmailSmtpHost"));
            String portValue = environment.getProperty("scheduleEmailPort");
            if (portValue == null || portValue.isEmpty() || portValue.equals("@scheduleEmailPort@")) {
                scheduleProperties.setEmailSMTPPort(25);
            } else {
                scheduleProperties.setEmailSMTPPort(Integer.parseInt(portValue));
            }
            String userName = environment.getProperty("scheduleEmailUsername");
            scheduleProperties.setEmailUserName(userName);
            scheduleProperties.setEmailPassword(environment.getProperty("scheduleEmailPassword"));
            scheduleProperties.setEmailTransportType(Integer.valueOf(environment.getProperty("scheduleEmailTypeOfConnection")).intValue());
            scheduleProperties.setEmailSender(userName);
        }
        return scheduleProperties;
    }

    @ConfigurationProperties(prefix="distributed.schedule")
    @Bean
    @Conditional(value={DWDistributeScheduleCondition.class})
    public DWDistributedScheduleWorkersProperties distributedScheduleWorkerProperties() {
        DWDistributedScheduleWorkersProperties distributedScheduleWorkerProperties = new DWDistributedScheduleWorkersProperties();
        return distributedScheduleWorkerProperties;
    }

    @Bean
    @Conditional(value={DWDistributeScheduleCondition.class})
    public DWScheduleDistributeWorkerConfigService scheduleDistributeWorkerConfigService(DWDistributedScheduleWorkersProperties distributedScheduleWorkerProperties) throws Exception {
        DWScheduleDistributeWorkerConfigService dwScheduleDistributeWorkerConfigService = new DWScheduleDistributeWorkerConfigService();
        dwScheduleDistributeWorkerConfigService.setWorkersProperties(distributedScheduleWorkerProperties);
        DWScheduleDistributeWorkerConfigService.setInstance((DWScheduleDistributeWorkerConfigService)dwScheduleDistributeWorkerConfigService);
        return dwScheduleDistributeWorkerConfigService;
    }

    @Bean(name={"dwDistributedScheduleRedisContainer"})
    @Conditional(value={DWDistributeScheduleCondition.class})
    public RedisMessageListenerContainer container(RedisConnectionFactory redisConnectionFactory, MessageListenerAdapter listenerAdapter, WorkerKeyExpirationListener workerKeyExpirationListener, @Qualifier(value="redisTemplate") RedisTemplate redisTemplate, Environment environment) throws Exception {
        DWQuartz.redisTemplate = redisTemplate;
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)listenerAdapter, (Topic)new PatternTopic("onlineWorkers"));
        DWScheduleWording.REDIS_KEYSPACE = String.format("__keyspace@%s__:", environment.getProperty("spring.data.redis.database", "0"));
        if (Boolean.parseBoolean(environment.getProperty("distributedScheduleHigherMaster"))) {
            DWQuartz.redisTemplate.keys((Object)"DWQuartz::worker::*").forEach(item -> DistributedScheduleUtils.onlineWorkers.put(item, redisTemplate.opsForValue().get(item)));
            List workIds = DistributedScheduleUtils.getAllWorkerIds();
            redisTemplate.delete((Object)"DWQuartz::subscribe::workers");
            workIds.forEach(item -> {
                container.addMessageListener((MessageListener)workerKeyExpirationListener, (Topic)new PatternTopic(DWScheduleWording.REDIS_KEYSPACE + "DWQuartz::worker::" + item));
                redisTemplate.opsForList().rightPush((Object)"DWQuartz::subscribe::workers", (Object)("DWQuartz::worker::" + item));
            });
        } else if (Boolean.parseBoolean(environment.getProperty("distributedScheduleWorker"))) {
            List workers = redisTemplate.opsForList().range((Object)"DWQuartz::subscribe::workers", 0L, -1L);
            workers.forEach(item -> container.addMessageListener((MessageListener)workerKeyExpirationListener, (Topic)new PatternTopic(DWScheduleWording.REDIS_KEYSPACE + item)));
        }
        return container;
    }

    @Bean
    @Conditional(value={DWDistributeScheduleCondition.class})
    public MessageListenerAdapter listenerAdapter() {
        return new MessageListenerAdapter((Object)new WorkerOnlineReceiver(), "receiveMessage");
    }

    @Bean
    @Conditional(value={DWDistributeScheduleCondition.class})
    public WorkerKeyExpirationListener workerKeyExpirationListener() {
        return new WorkerKeyExpirationListener();
    }

    @Bean(name={"DWQuartz"})
    @DependsOn(value={"dw-rdbMetadataLoader", "DWScheduleDBService", "DWScheduleRecordDBService", "dw-schedule-properties"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWQuartz quartz(final ConfigurableEnvironment environment, @Qualifier(value="dap-application-propertysource") PropertySource dapApplicationPropertySource) throws Exception {
        final Properties fixedValueProperties = new Properties();
        fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.driver", environment.getProperty("jdbcDriverClassName", ""));
        String dbUrl = environment.getProperty("dbUrl");
        if (StringUtils.isBlank((CharSequence)dbUrl)) {
            String dbUrlType = environment.getProperty("dbUrlType");
            String dbUrlHost = environment.getProperty("dbUrlHost");
            String dbUrlPort = environment.getProperty("dbUrlPort");
            String dbUrlDatabase = environment.getProperty("dbUrlDatabase");
            String dbUrlArgs = environment.getProperty("dbUrlArgs");
            StringBuilder dbUrlCombination = new StringBuilder();
            dbUrlCombination.append("jdbc:" + dbUrlType + "://" + dbUrlHost);
            if (!"".equals(dbUrlPort)) {
                dbUrlCombination.append(":" + dbUrlPort);
            }
            dbUrlCombination.append("/" + dbUrlDatabase);
            if (!"".equals(dbUrlArgs)) {
                dbUrlCombination.append("?" + dbUrlArgs);
            }
            dbUrl = dbUrlCombination.toString();
        }
        fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.URL", dbUrl);
        fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.user", environment.getProperty("dbUsername", ""));
        String dbPasswordEncryptionKey = environment.getProperty("dbPasswordEncryptionKey", "");
        String dbPassword = environment.getProperty("dbPassword", "");
        if (dbPasswordEncryptionKey != null && !"".equals(dbPasswordEncryptionKey.trim())) {
            dbPassword = AESUtil.decode((String)dbPassword, (String)dbPasswordEncryptionKey);
        }
        fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.password", dbPassword);
        fixedValueProperties.setProperty("org.quartz.jobStore.misfireThreshold", environment.getProperty("org.quartz.jobStore.misfireThreshold", "60000"));
        if (DistributedScheduleUtils.isWorker()) {
            fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.URL", DistributedScheduleUtils.workerProperties.getDbUrl());
            fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.user", DistributedScheduleUtils.workerProperties.getDbUserName());
            fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.password", DistributedScheduleUtils.workerProperties.getDbPassword());
        }
        DWQuartzProperties.buildDWQuartzProperties((Properties)fixedValueProperties);
        MutablePropertySources propSrcs = environment.getPropertySources();
        boolean isDefaultDataSourceName = "quartzDataSource".equals(environment.getProperty("org.quartz.jobStore.dataSource"));
        final Set keys = StreamSupport.stream(propSrcs.spliterator(), false).filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).filter(name -> isDefaultDataSourceName || name != null && !name.startsWith("org.quartz.dataSource.quartzDataSource.")).collect(Collectors.toSet());
        keys.addAll(fixedValueProperties.keySet().stream().map(k -> k.toString()).collect(Collectors.toSet()));
        DWQuartz quartz = new DWQuartz(new Properties(){

            @Override
            public String getProperty(String key) {
                String propertyValue = environment.getProperty(key);
                String leaderElectionScheduleEnabled = String.valueOf(environment.getProperty("leaderElectionScheduleEnabled", DWScheduleAutoConfiguration.KEY_FALSE));
                if ("true".equalsIgnoreCase(leaderElectionScheduleEnabled) && "org.quartz.jobStore.lockHandler.class".equals(key)) {
                    log.info((Object)"[leaderElectionSchedule] org.quartz.jobStore.lockHandler.class=org.quartz.impl.jdbcjobstore.NoLockSemaphore");
                    return "org.quartz.impl.jdbcjobstore.NoLockSemaphore";
                }
                return propertyValue == null ? fixedValueProperties.getProperty(key) : propertyValue;
            }

            @Override
            public String getProperty(String key, String defaultValue) {
                String propertyValue = environment.getProperty(key);
                String leaderElectionScheduleEnabled = String.valueOf(environment.getProperty("leaderElectionScheduleEnabled", DWScheduleAutoConfiguration.KEY_FALSE));
                if ("true".equalsIgnoreCase(leaderElectionScheduleEnabled) && "org.quartz.jobStore.lockHandler.class".equals(key)) {
                    log.info((Object)"[leaderElectionSchedule] org.quartz.jobStore.lockHandler.class=org.quartz.impl.jdbcjobstore.NoLockSemaphore");
                    return "org.quartz.impl.jdbcjobstore.NoLockSemaphore";
                }
                return propertyValue == null ? fixedValueProperties.getProperty(key) : propertyValue;
            }

            @Override
            public Enumeration<?> propertyNames() {
                return Collections.enumeration(keys);
            }

            @Override
            public Set<String> stringPropertyNames() {
                return keys;
            }
        });
        if (!Boolean.TRUE.equals(Boolean.parseBoolean(environment.getProperty("dap.schedule.start-up-after-app-started")))) {
            boolean leaderElectionScheduleEnabled = DWQuartz.isLeaderElectionScheduleEnabled();
            if (leaderElectionScheduleEnabled) {
                log.info((Object)"[leaderElectionSchedule] leaderElectionScheduleEnabled: true");
                quartz.standby();
                DWQuartz.electLeader();
            } else {
                quartz.startup();
            }
        }
        DWQuartz.setInstance((DWQuartz)quartz);
        return quartz;
    }

    @Bean
    @Conditional(value={DWLeaderElectionScheduleCondition.class})
    public LeaderElectionScheduler leaderElectionScheduler(ConfigurableEnvironment environment) {
        long clusterCheckinInterval = Long.valueOf(environment.getProperty("org.quartz.jobStore.clusterCheckinInterval", "20000"));
        long heartbeat = clusterCheckinInterval + clusterCheckinInterval / 2L;
        return new LeaderElectionScheduler(heartbeat);
    }

    @Bean(name={"DWScheduleContext"})
    @DependsOn(value={"DWScheduleDBService", "DWScheduleRecordDBService", "DWScheduleTimeDBService", "DWScheduleContactDBService", "DWQuartz", "dw-fuse-default-option"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleContext scheduleContext(ConfigurableEnvironment environment) {
        String isScheduleJsonOutputString = environment.getProperty("isScheduleJsonOutput", KEY_FALSE);
        boolean isScheduleJsonOutput = false;
        if ("true".equalsIgnoreCase(isScheduleJsonOutputString)) {
            isScheduleJsonOutput = true;
        }
        DWScheduleContext scheduleContext = new DWScheduleContext();
        DWScheduleContext.setInstance((DWScheduleContext)scheduleContext);
        scheduleContext.setScheduleJsonOutput(isScheduleJsonOutput);
        return scheduleContext;
    }

    @Bean(name={"DWScheduleDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleDBService scheduleDBService(ScheduleConfigProvider scheduleConfigProvider) {
        String tenantTagByColumnName = scheduleConfigProvider.getTenantTagByColumnName();
        String tenantColumnName = scheduleConfigProvider.getTenantColumnName();
        DWScheduleDBService.setTenantSqlTag((String)tenantTagByColumnName);
        DWScheduleDBService.setTenantColumnName((String)tenantColumnName);
        DWScheduleDBService scheduleDBService = new DWScheduleDBService();
        DWScheduleDBService.setInstance((DWScheduleDBService)scheduleDBService);
        return scheduleDBService;
    }

    @Bean(name={"DWScheduleRecordDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleRecordDBService scheduleRecordDBService(ScheduleConfigProvider scheduleConfigProvider) {
        String tenantTagByColumnName = scheduleConfigProvider.getTenantTagByColumnName();
        DWScheduleRecordDBService.setTenantSqlTag((String)tenantTagByColumnName);
        DWScheduleRecordDBService scheduleRecordDBService = new DWScheduleRecordDBService();
        DWScheduleRecordDBService.setInstance((DWScheduleRecordDBService)scheduleRecordDBService);
        return scheduleRecordDBService;
    }

    @Bean(name={"DWScheduleTimeDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleTimeDBService scheduleTimeDBService(ScheduleConfigProvider scheduleConfigProvider) {
        String tenantTagByColumnName = scheduleConfigProvider.getTenantTagByColumnName();
        String tenantColumnName = scheduleConfigProvider.getTenantColumnName();
        DWScheduleTimeDBService.setTenantSqlTag((String)tenantTagByColumnName);
        DWScheduleTimeDBService.setTenantColumnName((String)tenantColumnName);
        DWScheduleTimeDBService scheduleTimeDBService = new DWScheduleTimeDBService();
        DWScheduleTimeDBService.setInstance((DWScheduleTimeDBService)scheduleTimeDBService);
        return scheduleTimeDBService;
    }

    @Bean(name={"DWScheduleContactDBService"})
    @Conditional(value={DWScheduleEnableCondition.class})
    public DWScheduleContactDBService scheduleContactDBService(ScheduleConfigProvider scheduleConfigProvider) {
        String tenantTagByColumnName = scheduleConfigProvider.getTenantTagByColumnName();
        String tenantColumnName = scheduleConfigProvider.getTenantColumnName();
        DWScheduleContactDBService.setTenantSqlTag((String)tenantTagByColumnName);
        DWScheduleContactDBService.setTenantColumnName((String)tenantColumnName);
        DWScheduleContactDBService scheduleContactDBService = new DWScheduleContactDBService();
        DWScheduleContactDBService.setInstance((DWScheduleContactDBService)scheduleContactDBService);
        return scheduleContactDBService;
    }

    @PreDestroy
    public void onDestroy() throws Exception {
        LogFactory.getLog(DWScheduleAutoConfiguration.class).info((Object)"DWQuartz shutting down.");
        DWQuartz.shutdown();
        LogFactory.getLog(DWScheduleAutoConfiguration.class).info((Object)"DWQuartz shutdown complete.");
    }

    @Bean(value={"dw-datasource-properties"})
    @Conditional(value={DWScheduleEnableCondition.class})
    @DependsOn(value={"dw-http-client-properties"})
    public DWDaoDataSourceProperties dataSourceProperties(Environment environment) {
        DWDaoDataSourceProperties dataSourceProperties = new DWDaoDataSourceProperties();
        dataSourceProperties.setDbConnectionInitialSize(Integer.parseInt(environment.getProperty("dbConnectionInitialSize", "3")));
        dataSourceProperties.setDbConnectionMaxIdle(environment.getProperty("dbConnectionMaxIdle") == null ? null : Integer.valueOf(Integer.parseInt(environment.getProperty("dbConnectionMaxIdle"))));
        dataSourceProperties.setDbConnectionMaxTotal(Integer.parseInt(environment.getProperty("dbConnectionMaxTotal", "20")));
        dataSourceProperties.setDbConnectionMaxWaitMillis(Integer.parseInt(environment.getProperty("dbConnectionMaxWaitMillis", "60000")));
        dataSourceProperties.setDbConnectionMinIdle(Integer.parseInt(environment.getProperty("dbConnectionMinIdle", "3")));
        dataSourceProperties.setDbPassword(environment.getProperty("dbPassword"));
        dataSourceProperties.setDbPasswordEncryptionKey(environment.getProperty("dbPasswordEncryptionKey"));
        String dbUrl = environment.getProperty("dbUrl");
        if (StringUtils.isNotBlank((CharSequence)dbUrl)) {
            dataSourceProperties.setDbUrl(environment.getProperty("dbUrl"));
        } else {
            PropertySource propertySource;
            String dbUrlType = environment.getProperty("dbUrlType");
            String dbUrlHost = environment.getProperty("dbUrlHost");
            String dbUrlPort = environment.getProperty("dbUrlPort");
            String dbUrlDatabase = environment.getProperty("dbUrlDatabase");
            String dbUrlArgs = environment.getProperty("dbUrlArgs");
            StringBuilder dbUrlCombination = new StringBuilder();
            dbUrlCombination.append("jdbc:" + dbUrlType + "://" + dbUrlHost);
            if (!"".equals(dbUrlPort)) {
                dbUrlCombination.append(":" + dbUrlPort);
            }
            dbUrlCombination.append("/" + dbUrlDatabase);
            if (!"".equals(dbUrlArgs)) {
                dbUrlCombination.append("?" + dbUrlArgs);
            }
            if ((propertySource = ((ConfigurableEnvironment)environment).getPropertySources().get("dap-application-propertysource")) instanceof PropertiesPropertySource) {
                PropertiesPropertySource propertiesPropertySource = (PropertiesPropertySource)propertySource;
                ((Map)propertiesPropertySource.getSource()).put("dbUrl", dbUrlCombination.toString());
            }
            if (propertySource instanceof EnumerablePropertySource) {
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                Properties properties = (Properties)enumerablePropertySource.getSource();
                properties.setProperty("dbUrl", dbUrlCombination.toString());
            }
            dataSourceProperties.setDbUrl(dbUrlCombination.toString());
        }
        dataSourceProperties.setDbUsername(environment.getProperty("dbUsername"));
        dataSourceProperties.setDwDaoUnderScoreToCamelCase(Boolean.parseBoolean(environment.getProperty("dwDaoUnderScoreToCamelCase", "true")));
        dataSourceProperties.setJdbcDriverClassName(environment.getProperty("jdbcDriverClassName"));
        System.setProperty("dbRetryTimes", environment.getProperty("dap.db.connection.retryTimes", "3"));
        System.setProperty("dbRetryIntervalMillis", environment.getProperty("dap.db.connection.retryIntervalMillis", "2000"));
        if (Boolean.parseBoolean(environment.getProperty("distributedScheduleEnable")) && Boolean.parseBoolean(environment.getProperty("distributedScheduleWorker"))) {
            DWHttpClient client = new DWHttpClient();
            HttpPost post = new HttpPost(environment.getProperty("distributedScheduleMasterUrl") + "/restful/service/DWSys/IScheduleService/getWorkerConfig");
            DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties workerConfig = null;
            try {
                Map result = (Map)client.executeAndGetDWHttpResponseEntity((HttpUriRequest)post, Map.class).getResult();
                if (Boolean.parseBoolean(result.get("success").toString())) {
                    if (result.get("data") == null) {
                        throw new RuntimeException("can not get valid distributed schedule worker configuration");
                    }
                    Gson gson = new Gson();
                    workerConfig = (DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties)gson.fromJson(JSON.toJSONString(result.get("data")), DWDistributedScheduleWorkersProperties.DWDistributedScheduleWorkerProperties.class);
                } else {
                    throw new RuntimeException(result.get("message").toString());
                }
                dataSourceProperties.setDbPassword(workerConfig.getDbPassword());
                dataSourceProperties.setDbUrl(workerConfig.getDbUrl());
                dataSourceProperties.setDbUsername(workerConfig.getDbUserName());
                DistributedScheduleUtils.workerProperties = workerConfig;
            }
            catch (DWHttpFailedException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return dataSourceProperties;
    }
}

