/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.multi;

import com.digiwin.app.schedule.quartz.SingleQuartz;
import com.digiwin.app.schedule.quartz.multi.MultiQuartz;
import com.digiwin.app.schedule.quartz.multi.MultiQuartzElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.quartz.impl.DWStdScheduler;
import org.quartz.impl.DWStdSchedulerFactory;

public class DWMultiQuartz
implements MultiQuartz {
    public static final String BEAN_NAME = "DWMultiQuartz";
    private Map<String, SingleQuartz> quartzPool = new HashMap<String, SingleQuartz>();

    public void add(String dataSource, Properties quartzProperties) throws Exception {
        DWStdSchedulerFactory factory = new DWStdSchedulerFactory(quartzProperties);
        DWStdScheduler scheduler = (DWStdScheduler)factory.getScheduler();
        MultiQuartzElement multiQuartzElement = new MultiQuartzElement(scheduler);
        this.quartzPool.put(dataSource, multiQuartzElement);
    }

    public synchronized void startupElements() throws Exception {
        if (this.quartzPool.size() != 0) {
            Collection<SingleQuartz> values = this.quartzPool.values();
            for (SingleQuartz quartz : values) {
                quartz.startup();
            }
        }
    }

    public SingleQuartz get(String dataSource) {
        SingleQuartz quartz = this.quartzPool.getOrDefault(dataSource, null);
        return quartz;
    }

    public Map<String, SingleQuartz> getAll() {
        return this.quartzPool;
    }
}

