/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.utils;

import jakarta.servlet.http.HttpServletRequest;

public class WebExceptionHandlerHelper {
    private static final String DEFAULT_REQUEST_EXCEPTION_ATTRIBUTE_NAME = "request-exception";

    public static void handlerRequestException(HttpServletRequest request, Throwable t) {
        if (request == null) {
            return;
        }
        request.setAttribute(DEFAULT_REQUEST_EXCEPTION_ATTRIBUTE_NAME, (Object)t);
    }

    public static Throwable getCurrentRequestException(HttpServletRequest request) {
        return WebExceptionHandlerHelper.getRequestException(request, DEFAULT_REQUEST_EXCEPTION_ATTRIBUTE_NAME);
    }

    private static Throwable getRequestException(HttpServletRequest request, String attr) {
        if (request == null) {
            return null;
        }
        Throwable t = (Throwable)request.getAttribute(attr);
        request.removeAttribute(attr);
        return t;
    }
}

