/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.interceptor;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.SentinelWebInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.SentinelWebMvcConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.digiwin.sentinel.adapter.springwebmvc.config.DWSentinelWebMvcConfig;
import com.digiwin.sentinel.utils.WebExceptionHandlerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DWSentinelWebInterceptor
extends SentinelWebInterceptor {
    private final DWSentinelWebMvcConfig config;
    private static final String DEFAULT_ORIGIN = "";

    public DWSentinelWebInterceptor() {
        this(new DWSentinelWebMvcConfig());
    }

    public DWSentinelWebInterceptor(DWSentinelWebMvcConfig config) {
        super((SentinelWebMvcConfig)config);
        this.config = config == null ? new DWSentinelWebMvcConfig() : config;
    }

    protected String getResourceName(HttpServletRequest request) {
        return super.getResourceName(request);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.increaseReferece(request, this.config.getRequestRefName(), -1) != 0) {
            return;
        }
        Entry entry = this.getEntryInRequest(request, this.config.getRequestAttributeName());
        if (entry == null) {
            RecordLog.warn((String)"[{}] No entry found in request, key: {}", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.config.getRequestAttributeName()});
            return;
        }
        this.traceExceptionAndExit(request, entry, ex);
        this.removeEntryInRequest(request);
        ContextUtil.exit();
    }

    protected void traceExceptionAndExit(HttpServletRequest request, Entry entry, Exception ex) {
        if (entry != null) {
            if (ex != null) {
                Tracer.traceEntry((Throwable)ex, (Entry)entry);
            } else if (this instanceof DWSentinelWebInterceptor) {
                Throwable throwable = WebExceptionHandlerHelper.getCurrentRequestException((HttpServletRequest)request);
                Tracer.traceEntry((Throwable)throwable, (Entry)entry);
            }
            entry.exit();
        }
    }

    private Integer increaseReferece(HttpServletRequest request, String rcKey, int step) {
        Object obj = request.getAttribute(rcKey);
        if (obj == null) {
            obj = 0;
        }
        Integer newRc = (Integer)obj + step;
        request.setAttribute(rcKey, (Object)newRc);
        return newRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            String resourceName = this.getResourceName(request);
            if (StringUtil.isEmpty((String)resourceName)) {
                return true;
            }
            if (this.increaseReferece(request, this.config.getRequestRefName(), 1) != 1) {
                return true;
            }
            String origin = this.parseOrigin(request);
            RecordLog.info((String)"check origin, origin is: {}, resourceName is {}", (Object[])new Object[]{origin, resourceName});
            String contextName = this.getContextName(request);
            ContextUtil.enter((String)contextName, (String)origin);
            Entry entry = null;
            List<String> paramKeys = this.config.getParamKeys();
            Map<String, Object> map = this.config.getParamProvider().getFlowControlParams(request);
            if (paramKeys != null && !paramKeys.isEmpty() && map != null && !map.isEmpty()) {
                Object[] paramArray = this.fetchParams(paramKeys, map);
                RecordLog.info((String)"check param flow, param array is: {}", (Object[])paramArray);
                entry = paramArray != null && paramArray.length > 0 ? SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN, (Object[])paramArray) : SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN);
            } else {
                entry = SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN);
            }
            request.setAttribute(this.config.getRequestAttributeName(), (Object)entry);
            return true;
        }
        catch (BlockException e) {
            try {
                this.handleBlockException(request, response, e);
            }
            finally {
                ContextUtil.exit();
            }
            return false;
        }
    }

    protected Map<String, Object> getParamMap(HttpServletRequest request) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        if (this.config.getParamProvider() != null) {
            paramMap = this.config.getParamProvider().getFlowControlParams(request);
        }
        return paramMap;
    }

    protected Object[] fetchParams(List<String> keys, Map<String, Object> map) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (String key : keys) {
            Object value = map.get(key);
            params.add(value);
        }
        return params.toArray();
    }
}

