/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.spi;

import com.digiwin.sentinel.adapter.springwebmvc.spi.AbstractDWSentinelSpiLoader;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDWSentinelSpiLoader
extends AbstractDWSentinelSpiLoader {
    private static final Logger log = LoggerFactory.getLogger(DefaultDWSentinelSpiLoader.class);

    @Override
    public <T> T loadOrDefault(Class<T> spiClass, T defaultInstance) {
        return (T)CACHE.computeIfAbsent(spiClass, key -> {
            Object instance = this.loadFromSpi(spiClass);
            if (instance == null) {
                log.info("[DefaultDWSentinelSpiLoader] No SPI found for {}, using default: {}", (Object)spiClass.getSimpleName(), (Object)defaultInstance.getClass().getSimpleName());
                instance = defaultInstance;
            } else {
                log.info("[DefaultDWSentinelSpiLoader] SPI implementation loaded for {}: {}", (Object)spiClass.getSimpleName(), (Object)instance.getClass().getName());
            }
            return instance;
        });
    }

    protected <T> T loadFromSpi(Class<T> spiClass) {
        try {
            ServiceLoader<T> loader = ServiceLoader.load(spiClass);
            Iterator<T> iterator = loader.iterator();
            if (iterator.hasNext()) {
                T impl = iterator.next();
                log.info("[DefaultDWSentinelSpiLoader] Loaded {} -> {}", (Object)spiClass.getSimpleName(), (Object)impl.getClass().getName());
                return impl;
            }
            log.info("[DefaultDWSentinelSpiLoader] No SPI implementation found in META-INF/services for {}", (Object)spiClass.getSimpleName());
        }
        catch (Throwable t) {
            log.warn("[DefaultDWSentinelSpiLoader] Failed to load SPI for {}", (Object)spiClass.getSimpleName(), (Object)t);
        }
        return null;
    }
}

