/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.spi;

import com.digiwin.sentinel.adapter.springwebmvc.spi.DefaultDWSentinelSpiLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringDWSentinelSpiLoader
extends DefaultDWSentinelSpiLoader {
    private static final Logger log = LoggerFactory.getLogger(SpringDWSentinelSpiLoader.class);
    private static ApplicationContext applicationContext;

    public SpringDWSentinelSpiLoader(ApplicationContext context) {
        applicationContext = context;
    }

    @Override
    public <T> T loadOrDefault(Class<T> spiClass, T defaultInstance) {
        T instance = super.loadOrDefault(spiClass, defaultInstance);
        this.autowireIfNecessary(instance);
        return instance;
    }

    private void autowireIfNecessary(Object bean) {
        if (bean == null || applicationContext == null) {
            return;
        }
        if (!this.hasSpringInjectionAnnotation(bean.getClass())) {
            return;
        }
        try {
            AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
            beanFactory.autowireBean(bean);
            log.debug("[SpringDWSentinelSpiLoader] Autowired {}", (Object)bean.getClass().getName());
        }
        catch (Exception e) {
            log.warn("[SpringDWSentinelSpiLoader] Autowire failed for {}", (Object)bean.getClass().getName(), (Object)e);
        }
    }

    private boolean hasSpringInjectionAnnotation(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation ann : field.getAnnotations()) {
                String type = ann.annotationType().getName();
                if (!"org.springframework.beans.factory.annotation.Autowired".equals(type) && !"javax.annotation.Resource".equals(type) && !"org.springframework.beans.factory.annotation.Value".equals(type)) continue;
                return true;
            }
        }
        return false;
    }
}

