/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.interceptor;

import com.alibaba.csp.sentinel.slots.block.BlockException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-1)
public class DWSentinelExceptionAware
implements HandlerExceptionResolver {
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.addExceptionToRequest(request, ex);
        return null;
    }

    private void addExceptionToRequest(HttpServletRequest httpServletRequest, Exception exception) {
        if (BlockException.isBlockException((Throwable)exception)) {
            return;
        }
        httpServletRequest.setAttribute("$$sentinel_spring_web_entry_attr-exception", (Object)exception);
    }
}

