/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission.config;

import com.digiwin.gateway.service.permission.metadata.DWDeductCountMode;

public class DWServicePermissionConfig {
    public static final boolean DEFAULT_VALID_USER_PERMISSION = false;
    public static final boolean DEFAULT_VALID_TENANT_PERMISSION = false;
    public static final boolean DEFAULT_OPEN_TRUST_CHAIN = true;
    private boolean validUserPermission = false;
    private boolean validTenantPermission = false;
    private static final int API_AUTH_MODE_SUBSCRIPTION_PERMISSION = 0;
    private int authorizationMode = -1;
    private DWDeductCountMode defaultDeductCountMode = null;
    private boolean openTrustChain = true;
    private String appId;
    private String appToken;
    private String iamHostUrl;
    private String ramHostUrl;
    private String cacHostUrl;

    public boolean isValidUserPermission() {
        return this.validUserPermission;
    }

    public void setValidUserPermission(boolean validUserPermission) {
        this.validUserPermission = validUserPermission;
    }

    public boolean isValidTenantPermission() {
        return this.validTenantPermission;
    }

    public void setValidTenantPermission(boolean validTenantPermission) {
        this.validTenantPermission = validTenantPermission;
    }

    public boolean isValidSubscriptionPermission() {
        return this.authorizationMode == 0;
    }

    public void setApiAuthorizationMode(int authorizationMode) {
        this.authorizationMode = authorizationMode;
    }

    public boolean isApiAuthorizationEnabled() {
        return DWServicePermissionConfig.isApiAuthorizationEnabled(this.authorizationMode);
    }

    public static boolean isApiAuthorizationEnabled(int authorizationMode) {
        return authorizationMode >= 0 && authorizationMode <= 2;
    }

    public int getAuthorizationMode() {
        return this.authorizationMode;
    }

    public DWDeductCountMode getDefaultDeductCountMode() {
        return this.defaultDeductCountMode;
    }

    public void setDefaultDeductCountMode(DWDeductCountMode defaultDeductCountMode) {
        this.defaultDeductCountMode = defaultDeductCountMode;
        if (this.defaultDeductCountMode == null) {
            this.defaultDeductCountMode = DWDeductCountMode.CUSTOM;
        }
    }

    public boolean isOpenTrustChain() {
        return this.openTrustChain;
    }

    public void setOpenTrustChain(boolean openTrustChain) {
        this.openTrustChain = openTrustChain;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getIamHostUrl() {
        return this.iamHostUrl;
    }

    public void setIamHostUrl(String iamHostUrl) {
        this.iamHostUrl = iamHostUrl;
    }

    public String getCacHostUrl() {
        return this.cacHostUrl;
    }

    public void setCacHostUrl(String cacHostUrl) {
        this.cacHostUrl = cacHostUrl;
    }

    public String getRamHostUrl() {
        return this.ramHostUrl;
    }

    public void setRamHostUrl(String ramHostUrl) {
        this.ramHostUrl = ramHostUrl;
    }
}

