/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission.util;

import com.dap.component.service.permission.api.ServicePermissionRequestContextProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.gateway.service.permission.config.DWServicePermissionConfig;
import com.digiwin.gateway.service.permission.metadata.DWAPIPermission;
import com.digiwin.gateway.service.permission.metadata.DWDeductCountMode;
import com.digiwin.service.permission.auth.DWAuthorizationVerifier;
import com.digiwin.service.permission.auth.param.DeductAuthorizationCountParam;
import java.lang.reflect.Method;
import java.util.Objects;

public final class DWAPIPermissionUtil {
    private DWServicePermissionConfig config;
    private DWAuthorizationVerifier verifier;

    public DWAPIPermissionUtil(DWServicePermissionConfig config, DWAuthorizationVerifier verifier) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(verifier);
        this.config = config;
        this.verifier = verifier;
    }

    public DWServicePermissionConfig getConfig() {
        return this.config;
    }

    public DWAuthorizationVerifier getVerifier() {
        return this.verifier;
    }

    public boolean shouldCheckPermission(Method method) {
        if (!this.config.isApiAuthorizationEnabled()) {
            return false;
        }
        if (method == null) {
            return true;
        }
        return method.isAnnotationPresent(DWAPIPermission.class);
    }

    public DWDeductCountMode getDeductCountMode(DWAPIPermission metadata) {
        DWDeductCountMode mode = metadata.autoDeductMode();
        if (mode == DWDeductCountMode.CONFIG) {
            return this.getConfig().getDefaultDeductCountMode();
        }
        return mode;
    }

    public Object deductAuthorizationCount(int deductCount) throws Exception {
        ServicePermissionRequestContextProvider requestContextProvider = (ServicePermissionRequestContextProvider)SpringContextUtils.getBean((String)"servicePermissionRequestContextProvider");
        String authSecretKey = requestContextProvider.getAuthSecretKey();
        DeductAuthorizationCountParam deductParam = new DeductAuthorizationCountParam();
        deductParam.setAuthSecretKey(authSecretKey);
        deductParam.setDecreaseCount(deductCount);
        return this.verifier.deductAuthorizationCount(this.getConfig().getCacHostUrl(), this.getConfig().getAppToken(), deductParam);
    }
}

