/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient;

import com.dap.component.serviceclient.api.ConnAuthKeyProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.persistconn.ApInfoProvider;
import com.digiwin.app.persistconn.SimpleReceiver;
import com.digiwin.app.persistconn.TenantIdProvider;
import com.digiwin.app.persistconn.TokenProvider;
import com.digiwin.app.persistconn.client.DWRpcClient;
import com.digiwin.app.persistconn.client.ReRegisterV01;
import com.digiwin.app.persistconn.client.Register;
import com.digiwin.app.persistconn.client.RegisterTopicV01;
import com.digiwin.app.persistconn.client.RegisterV01;
import com.digiwin.app.queue.Command;
import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.app.serviceclient.exception.ConnAuthKeyException;
import com.digiwin.app.serviceclient.exception.OperationException;
import com.digiwin.app.serviceclient.util.ServiceClientUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class TenantAdminServiceClient {
    private static Log log = LogFactory.getLog(TenantAdminServiceClient.class);
    private static final String TAG = "[TenantAdminServiceClient] ";

    public String simpleRegisterGateway(String gatewayName, String apName) {
        SimpleReceiver simpleReceiver = new SimpleReceiver();
        return this.registerGateway(gatewayName, apName, simpleReceiver);
    }

    public String registerGateway(String gatewayName, String apName, DWQueueReceiver receiver) {
        ConnAuthKeyProvider connAuthKeyProvider = (ConnAuthKeyProvider)SpringContextUtils.getBean(ConnAuthKeyProvider.class);
        String connAuthKey = null;
        try {
            connAuthKey = connAuthKeyProvider.get();
        }
        catch (Exception e) {
            new ConnAuthKeyException(e);
        }
        if (StringUtils.isBlank((CharSequence)connAuthKey)) {
            throw new ConnAuthKeyException("no ConnAuthKey");
        }
        Register client = new Register(gatewayName, apName, connAuthKey, receiver);
        String result = null;
        try {
            result = ((DWRpcClient)client).invoke();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        JSONObject jo = new JSONObject(result);
        boolean registerResult = jo.optBoolean("result", false);
        if (!registerResult) {
            log.error((Object)"[TenantAdminServiceClient] register gateway failed");
        }
        String tenantId = jo.optString("tenantId", "");
        String tenantSid = jo.optString("tenantSid", "");
        String token = jo.optString("token", "");
        TenantIdProvider.setTenantId(tenantId);
        TenantIdProvider.setTenantSid(tenantSid);
        TokenProvider.setToken(token);
        return result;
    }

    @Deprecated
    public String registerGateway(String userId, String password, String gatewayName, String apName) throws Exception {
        ApInfoProvider.setGatewayName(gatewayName);
        ApInfoProvider.setApName(apName);
        RegisterV01 client = new RegisterV01(userId, password, gatewayName, apName);
        String result = ((DWRpcClient)client).invoke();
        JSONObject jo = new JSONObject(result);
        boolean registerResult = jo.optBoolean("result", false);
        if (!registerResult) {
            log.error((Object)"[TenantAdminServiceClient] register gateway failed");
        }
        String tenantId = jo.optString("tenantId", "");
        TenantIdProvider.setTenantId(tenantId);
        return result;
    }

    @Deprecated
    public String reRegisterGateway(String gatewayId, String gatewayName, String apName) throws Exception {
        return this.reRegisterGateway(gatewayId, gatewayName, apName, -1, -1);
    }

    @Deprecated
    public String reRegisterGateway(String gatewayId, String gatewayName, String apName, int retryTimes, int retryIntervalSec) throws Exception {
        ApInfoProvider.setGatewayName(gatewayName);
        ApInfoProvider.setApName(apName);
        ReRegisterV01 client = new ReRegisterV01(gatewayId, gatewayName, apName, retryTimes, retryIntervalSec);
        String result = ((DWRpcClient)client).invoke();
        JSONObject jo = new JSONObject(result);
        boolean registerResult = jo.optBoolean("result", false);
        if (!registerResult) {
            log.error((Object)"[TenantAdminServiceClient] register gateway failed");
        }
        String tenantId = jo.optString("tenantId", "");
        TenantIdProvider.setTenantId(tenantId);
        return result;
    }

    @Deprecated
    public void registerTopic(String gatewayId, Command command, DWQueueReceiver receiver) throws Exception {
        String gatewayName = ApInfoProvider.getGatewayName();
        String apName = ApInfoProvider.getApName();
        RegisterTopicV01 client = new RegisterTopicV01(gatewayId, gatewayName, apName, receiver);
        ((DWRpcClient)client).invoke();
    }
}

