/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.client;

import com.dap.component.serviceclient.api.ServiceProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.persistconn.DWResourcePojo;
import com.digiwin.app.persistconn.client.DWRpcClient;
import com.digiwin.app.persistconn.client.InvokeOtherDapService;
import com.digiwin.app.persistconn.client.InvokeSaasService;
import com.digiwin.app.persistconn.client.InvokeThisDapService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class InvokeDapService
extends DWRpcClient {
    private DWResourcePojo pojo;
    private String apName;
    private String moduleName;
    private String serviceName;
    private String methodName;
    private Map<String, Object> parameters;

    public InvokeDapService(DWResourcePojo pojo) {
        this.pojo = pojo;
        this.apName = pojo.getApName();
        this.moduleName = pojo.getModuleName();
        this.serviceName = pojo.getServiceName();
        this.methodName = pojo.getMethodName();
        this.parameters = pojo.getParameters();
    }

    @Override
    public String invoke() throws Exception {
        ServiceProvider serviceProvider = (ServiceProvider)SpringContextUtils.getBean(ServiceProvider.class);
        boolean contain = serviceProvider.isContain(this.moduleName, this.serviceName, this.methodName, this.parameters);
        if (contain) {
            InvokeThisDapService client = new InvokeThisDapService(this.pojo);
            String result = ((DWRpcClient)client).invoke();
            return result;
        }
        if (!StringUtils.isBlank((CharSequence)SpringContextUtils.getEnvironment().getProperty("OtherDapUrl" + this.apName))) {
            InvokeOtherDapService client = new InvokeOtherDapService(this.pojo);
            String result = ((DWRpcClient)client).invoke();
            return result;
        }
        InvokeSaasService client = new InvokeSaasService(this.pojo);
        String result = ((DWRpcClient)client).invoke();
        return result;
    }
}

