/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.util;

import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.exception.DWServerErrorException;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpRequestFuse
implements DWReturnFuse<String> {
    private static Log log = LogFactory.getLog(HttpRequestFuse.class);
    private static CloseableHttpClient httpClient;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(DWFuseParameter fuseParameter) throws Exception {
        HttpPost httpPost = (HttpPost)fuseParameter.get("httpPost");
        String result = "";
        int statusCode = -1;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            InputStream content = response.getEntity().getContent();
            if (content == null) {
                String string = result;
                return string;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(content, StandardCharsets.UTF_8);
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                StringBuffer stringBuffer = new StringBuffer("");
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                result = stringBuffer.toString();
            }
            statusCode = response.getStatusLine().getStatusCode();
        }
        if (statusCode != 429 && statusCode != 502 && statusCode != 503) {
            if (statusCode != 504) return result;
        }
        log.warn((Object)("[ServiceClient] HTTP Status Code: " + statusCode + ", result: " + result));
        throw new DWServerErrorException(statusCode, result);
    }

    static {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(500);
        manager.setDefaultMaxPerRoute(500);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
        IdleConnectionMonitorThread monitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)manager);
        monitor.start();
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager manager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager manager) {
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.manager.closeExpiredConnections();
                        this.manager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

