/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.client;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.persistconn.DWQueueClientProvider;
import com.digiwin.app.persistconn.DWResourcePojo;
import com.digiwin.app.persistconn.StandardCompleteCallback;
import com.digiwin.app.persistconn.StandardTimeoutCallback;
import com.digiwin.app.persistconn.TenantIdProvider;
import com.digiwin.app.persistconn.client.DWRpcClient;
import com.digiwin.queue.saas.SaasClient;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class InvokeTenantDapService
extends DWRpcClient {
    private String gatewayId;
    private String apName;
    private String moduleName;
    private String serviceName;
    private String methodName;
    private Map<String, Object> parameters;
    private Integer timeout;
    private TimeUnit timeoutUnit;

    public InvokeTenantDapService(String gatewayId, DWResourcePojo pojo, Integer timeout, TimeUnit timeoutUnit) {
        this.gatewayId = gatewayId;
        this.apName = pojo.getApName();
        this.moduleName = pojo.getModuleName();
        this.serviceName = pojo.getServiceName();
        this.methodName = pojo.getMethodName();
        this.parameters = pojo.getParameters();
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    @Override
    public String invoke() throws Exception {
        JSONObject jo = new JSONObject();
        jo.put("apName", (Object)this.apName);
        jo.put("moduleName", (Object)this.moduleName);
        jo.put("serviceName", (Object)this.serviceName);
        jo.put("methodName", (Object)this.methodName);
        jo.put("parameter", (Object)DWGsonProvider.getGson().toJson(this.parameters, this.parameters.getClass()));
        ArrayBlockingQueue<String> response = new ArrayBlockingQueue<String>(1);
        StandardCompleteCallback completeCallback = new StandardCompleteCallback(response);
        StandardTimeoutCallback timeoutCallback = new StandardTimeoutCallback(response);
        String tenantId = TenantIdProvider.getTenantId();
        SaasClient saasClient = DWQueueClientProvider.getSaasClient();
        if (this.timeout <= 0) {
            saasClient.onSend(tenantId, this.gatewayId, jo.toString(), (SaasClient.CompleteCallback)completeCallback, (SaasClient.TimeoutCallback)timeoutCallback, Integer.valueOf(2), TimeUnit.HOURS);
        } else {
            saasClient.onSend(tenantId, this.gatewayId, jo.toString(), (SaasClient.CompleteCallback)completeCallback, (SaasClient.TimeoutCallback)timeoutCallback, this.timeout, this.timeoutUnit);
        }
        return (String)response.take();
    }
}

