/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.rpc;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.serviceclient.rpc.DWInvTarget;
import com.digiwin.http.client.utils.DWURIBuilder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

public class DWDapInvTarget
extends DWInvTarget {
    private URI uri;
    private String action;
    private String appId;
    private String moduleName;
    private String interfaceName;
    private String methodName;

    private DWDapInvTarget(URI uri, String action) {
        super(uri, action);
        this.uri = uri;
        this.action = action;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static DWDapInvTarget createServiceRouteDapAPI(String moduleName, String interfaceName, String methodName) throws MalformedURLException, URISyntaxException {
        URI uri = DWURIBuilder.createServiceRouteDapAPI((String)moduleName, (String)interfaceName, (String)methodName).build();
        DWDapInvTarget invTarget = new DWDapInvTarget(uri, "POST");
        invTarget.appId = uri.getHost();
        invTarget.moduleName = moduleName;
        invTarget.interfaceName = interfaceName;
        invTarget.methodName = methodName;
        return invTarget;
    }

    public static DWDapInvTarget createServiceRouteDapAPI(String appId, String moduleName, String interfaceName, String methodName) throws MalformedURLException, URISyntaxException {
        String moduleNameActual = moduleName;
        String moduleNameFromConfig = SpringContextUtils.getEnvironment().getProperty(moduleName + "Module");
        if (moduleNameFromConfig != null) {
            moduleNameActual = moduleNameFromConfig;
        }
        URI uri = DWURIBuilder.createServiceRouteDapAPI((String)appId, (String)moduleNameActual, (String)interfaceName, (String)methodName).build();
        DWDapInvTarget invTarget = new DWDapInvTarget(uri, "POST");
        invTarget.appId = appId;
        invTarget.moduleName = moduleNameActual;
        invTarget.interfaceName = interfaceName;
        invTarget.methodName = methodName;
        return invTarget;
    }
}

