/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn;

import com.digiwin.app.persistconn.DWResourcePojo;
import com.digiwin.app.persistconn.client.InvokeThisDapService;
import com.digiwin.app.queue.DWQueueReceiver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class SimpleReceiver
extends DWQueueReceiver {
    private static Log log = LogFactory.getLog(SimpleReceiver.class);
    private static final String TAG = "[SimpleReceiver] ";

    public void onReceive(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            JSONObject messageBlankJo = new JSONObject();
            messageBlankJo.put("message", (Object)"message can't be null or empty");
            super.onFail(messageBlankJo.toString());
            return;
        }
        JSONObject jo = new JSONObject("{}");
        try {
            jo = new JSONObject(message);
        }
        catch (Exception e) {
            String errorMessage = ExceptionUtils.getStackTrace((Throwable)e);
            log.error((Object)(TAG + errorMessage));
            JSONObject jsonFormatErrorJo = new JSONObject();
            jsonFormatErrorJo.put("message", (Object)errorMessage);
            super.onFail(jsonFormatErrorJo.toString());
            return;
        }
        if (!(jo.has("apName") && jo.has("moduleName") && jo.has("serviceName") && jo.has("methodName"))) {
            JSONObject formatErrorJo = new JSONObject();
            formatErrorJo.put("message", (Object)"message must contain apName or moduleName or serviceName or methodName");
            super.onFail(formatErrorJo.toString());
            return;
        }
        String apName = jo.optString("apName", "");
        String moduleName = jo.optString("moduleName", "");
        String serviceName = jo.optString("serviceName", "");
        String methodName = jo.optString("methodName", "");
        String parameter = jo.optString("parameter", "{}");
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, new JSONObject(parameter).toMap());
        InvokeThisDapService rpcClient = new InvokeThisDapService(pojo);
        try {
            String result = rpcClient.invoke();
            super.onSuccess(result);
            return;
        }
        catch (Exception e) {
            String errorMessage = ExceptionUtils.getStackTrace((Throwable)e);
            log.error((Object)(TAG + errorMessage));
            JSONObject errorJo = new JSONObject();
            errorJo.put("message", (Object)errorMessage);
            super.onFail(errorJo.toString());
            return;
        }
    }
}

