/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.rpc.protocol.http;

import com.dap.component.serviceclient.api.ServiceClientServiceProvider;
import com.digiwin.app.container.exceptions.DWInvocationException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.serviceclient.exception.DWLocalInvocationException;
import com.digiwin.app.serviceclient.rpc.DWDapInvTarget;
import com.digiwin.app.serviceclient.rpc.IDWInvMessage;
import com.digiwin.app.serviceclient.rpc.IDWInvocation;
import com.digiwin.app.serviceclient.rpc.IDWInvoker;
import com.digiwin.app.serviceclient.rpc.protocol.IDWInvTarget;
import com.digiwin.app.serviceclient.rpc.protocol.http.DWHttpRequestConverter;
import com.digiwin.http.client.DWHttpClient;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.core.env.Environment;

public class DWHttpInvoker
implements IDWInvoker {
    String appId;

    public DWHttpInvoker() {
        Environment environment = SpringContextUtils.getEnvironment();
        this.appId = environment.getProperty("appId");
    }

    @Override
    public <R> R invoke(IDWInvocation invocation, Class<R> resultType) throws DWInvocationException, IOException {
        return this.invoke(invocation, (Type)resultType);
    }

    private <R> R covert(Object result, Type entityTypeOfR) throws DWLocalInvocationException {
        Gson gson = DWGsonProvider.getGson();
        String jsonString = gson.toJson(result);
        if (entityTypeOfR == String.class) {
            return (R)jsonString;
        }
        Object newTypeInstance = gson.fromJson(jsonString, entityTypeOfR);
        return (R)newTypeInstance;
    }

    @Override
    public <R> R invoke(IDWInvocation invocation, Type entityTypeOfR) throws DWInvocationException, IOException {
        Object entity;
        if (this.isSameApp(invocation.getTarget())) {
            DWDapInvTarget thisDapInvTarget = (DWDapInvTarget)invocation.getTarget();
            String moduleName = thisDapInvTarget.getModuleName();
            String interfaceName = thisDapInvTarget.getInterfaceName();
            String methodName = thisDapInvTarget.getMethodName();
            entity = invocation.getMessage().getEntity();
            ServiceClientServiceProvider serviceProvider = (ServiceClientServiceProvider)SpringContextUtils.getBean((String)"serviceClientServiceProvider");
            boolean sameAppContain = serviceProvider.isSameAppContain(moduleName, interfaceName, methodName, entity);
            if (sameAppContain) {
                serviceProvider.invokeSameApp(moduleName, interfaceName, methodName, entity);
            }
        }
        DWHttpClient client = new DWHttpClient();
        HttpUriRequest request = DWHttpRequestConverter.convert(invocation);
        IDWInvMessage message = invocation.getMessage();
        Map<String, String> headers = message.getHeaders();
        headers.entrySet().stream().forEach(item -> request.addHeader((String)item.getKey(), (String)item.getValue()));
        if (request instanceof HttpEntityEnclosingRequest && (entity = invocation.getMessage().getEntity()) != null) {
            Gson gson = DWGsonProvider.getGson();
            String json = gson.toJson(entity);
            StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)stringEntity);
        }
        return (R)client.execute(request, entityTypeOfR);
    }

    private boolean isSameApp(IDWInvTarget invocationTarget) {
        if (invocationTarget instanceof DWDapInvTarget) {
            DWDapInvTarget dapInvTarget = (DWDapInvTarget)invocationTarget;
            String targetAppId = dapInvTarget.getAppId();
            return this.appId == null ? false : this.appId.equalsIgnoreCase(targetAppId);
        }
        return false;
    }
}

