/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.rpc.concurrent;

import com.digiwin.app.serviceclient.rpc.concurrent.DWFutureTask;
import com.digiwin.app.serviceclient.rpc.concurrent.DWServiceCallable;
import com.digiwin.app.serviceclient.rpc.concurrent.DWServiceFutureTask;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;

public class DWFutureTaskExecutor {
    private ExecutorService threadPool = null;
    private Map<String, DWFutureTask<?>> tasks = new LinkedHashMap();

    public <T> void add(String taskName, DWFutureTask<T> futureTask) {
        if (StringUtils.isBlank((CharSequence)taskName)) {
            throw new IllegalArgumentException("param taskName can't be empty.");
        }
        this.tasks.put(taskName, futureTask);
    }

    public <T> void add(String taskName, DWServiceCallable<T> taskCallable) {
        DWServiceFutureTask<T> futureTask = new DWServiceFutureTask<T>(taskCallable);
        this.add(taskName, futureTask);
    }

    public <T> void add(String taskName, Callable<T> taskCallable) {
        DWFutureTask<T> futureTask = new DWFutureTask<T>(taskCallable);
        this.add(taskName, futureTask);
    }

    public void run() {
        this.initThreadPool();
        for (Map.Entry<String, DWFutureTask<?>> entry : this.tasks.entrySet()) {
            DWFutureTask<?> futureTask = entry.getValue();
            this.threadPool.execute(futureTask);
        }
    }

    private void initThreadPool() {
        this.threadPool = this.tasks.keySet().size() == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(this.tasks.keySet().size());
    }

    public Map<String, DWFutureTask<?>> getTasks() {
        return this.tasks;
    }

    public <T> DWFutureTask<T> getTask(String taskName) {
        return this.tasks.get(taskName);
    }

    public <T> DWServiceFutureTask<T> getDWServiceFutureTask(String taskName) {
        return (DWServiceFutureTask)this.getTask(taskName);
    }
}

