/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway;

import com.digiwin.gateway.spring.DWServerSpringResourceReader;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ImportResource;

@SpringBootApplication(exclude={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
@ImportResource(value={"dwweb:platform.properties"}, reader=DWServerSpringResourceReader.class)
public class DWApiGatewayApplication
extends SpringBootServletInitializer
implements ApplicationListener<ServletWebServerInitializedEvent> {
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        LoggerFactory.getLogger(DWApiGatewayApplication.class).info("DAP running in standalone tomcat...");
        return builder.sources(new Class[]{DWApiGatewayApplication.class});
    }

    public static void main(String[] args) throws Exception {
        SpringApplication springApplication = new SpringApplication(new Class[]{DWApiGatewayApplication.class});
        springApplication.addListeners(new ApplicationListener[]{new ApplicationPidFileWriter("DWApiGatewayApplication.pid")});
        springApplication.setMainApplicationClass(DWApiGatewayApplication.class);
        springApplication.run(args);
    }

    public void onApplicationEvent(ServletWebServerInitializedEvent event) {
        System.out.println("contextPath = " + event.getApplicationContext().getServletContext().getContextPath());
    }
}

