/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.remote;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.application.ApplicationConfigFile;
import com.digiwin.apollo.application.ApplicationConfigService;
import com.digiwin.apollo.platform.PlatformConfigFile;
import com.digiwin.apollo.platform.PlatformConfigService;
import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.config.ConfigType;
import com.digiwin.app.common.config.Extension;
import com.digiwin.app.common.config.ExtensionUtils;
import com.digiwin.app.common.config.reader.BaseReader;
import com.digiwin.app.common.config.reader.resource.LocaleReader;
import com.digiwin.app.common.config.remote.ConfigInfo;
import com.digiwin.app.module.DWModuleClassLoader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteReader
implements BaseReader {
    private static final String TAG = "[RemoteReader] ";
    private static final String CANT_FIND_FORM_REMOTE = "can't find from remote - ";
    private static final String KEY_SHARE = "share.";
    private static Log log = LogFactory.getLog(RemoteReader.class);

    @Override
    public String getLog4j2Xml() {
        String content = this.getXmlConfigFileString(ConfigType.APPLICATION, "log4j2");
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)"[RemoteReader] can't find from remote - log4j2");
            return null;
        }
        return content;
    }

    @Override
    public String getPlatformModuleSpringXml(String module, String xmlNameWithoutExtension) {
        String key = module + "." + xmlNameWithoutExtension;
        String content = this.getXmlConfigFileString(ConfigType.PLATFORM, key);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[RemoteReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getModuleSpringXml(String module, String xmlNameWithoutExtension) {
        String key = module + "." + xmlNameWithoutExtension;
        String content = this.getXmlConfigFileString(ConfigType.MODULE, key);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[RemoteReader] can't find from remote - " + key));
            key = KEY_SHARE + xmlNameWithoutExtension;
            content = this.getXmlConfigFileString(ConfigType.MODULE, key);
            if (StringUtils.isBlank((CharSequence)content)) {
                log.debug((Object)("[RemoteReader] can't find from remote - " + key));
                return null;
            }
        }
        return content;
    }

    @Override
    public String getApplicationSpringXml(String xmlNameWithoutExtension) {
        String key = xmlNameWithoutExtension;
        String content = this.getXmlConfigFileString(ConfigType.APPLICATION, key);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[RemoteReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getPlatformSpringXml(String xmlNameWithoutExtension) {
        String key = "platform." + xmlNameWithoutExtension;
        String content = this.getXmlConfigFileString(ConfigType.PLATFORM, key);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[RemoteReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getModuleResource(String module, String nameWithoutExtension, Extension extension) {
        ConfigFileFormat configFileFormat;
        String key = module + "." + nameWithoutExtension;
        String content = this.getConfigFileString(ConfigType.MODULE, key, configFileFormat = ExtensionUtils.toConfigFileFormat(extension));
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[RemoteReader] can't find from remote - " + key));
            key = KEY_SHARE + nameWithoutExtension;
            content = this.getConfigFileString(ConfigType.MODULE, key, configFileFormat);
            if (StringUtils.isBlank((CharSequence)content)) {
                log.debug((Object)("[RemoteReader] can't find from remote - " + key));
                return null;
            }
        }
        return content;
    }

    @Override
    public String getApplicationResource(String nameWithoutExtension, Extension extension) {
        String key = nameWithoutExtension;
        ConfigFileFormat configFileFormat = ExtensionUtils.toConfigFileFormat(extension);
        String content = this.getConfigFileString(ConfigType.APPLICATION, key, configFileFormat);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[RemoteReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getPlatformResource(String fileBaseName, Extension fileExtension) {
        String key = fileBaseName;
        ConfigFileFormat configFileFormat = ExtensionUtils.toConfigFileFormat(fileExtension);
        String content = this.getConfigFileString(ConfigType.PLATFORM, key, configFileFormat);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[RemoteReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public Properties getProperties(String path, String propertiesNameWithoutExtension) {
        ConfigInfo configInfo = ConfigInfo.get(path, propertiesNameWithoutExtension);
        return this.getProperties(configInfo);
    }

    private Properties getProperties(ConfigInfo configInfo) {
        Properties properties;
        String content;
        Object key;
        if (configInfo == null) {
            return new Properties();
        }
        ConfigType configType = configInfo.getConfigType();
        String fileNameWithoutExtension = configInfo.getFileNameWithoutExtension();
        String modifiedFileName = configInfo.getModifiedFileName();
        Properties mergedProperties = new Properties();
        if (ConfigType.MODULE.equals((Object)configType)) {
            key = KEY_SHARE + fileNameWithoutExtension;
            content = this.getConfigFileString(configType, (String)key, ConfigFileFormat.Properties);
            if (StringUtils.isNotBlank((CharSequence)content)) {
                properties = new Properties();
                try {
                    properties.load(new StringReader(content));
                }
                catch (IOException e) {
                    log.error((Object)("parse remote properties error, error message=" + e.getMessage()));
                    return new Properties();
                }
                mergedProperties.putAll((Map<?, ?>)properties);
            } else {
                log.debug((Object)("[RemoteReader] can't find from remote - " + (String)key));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(content = this.getConfigFileString(configType, (String)(key = modifiedFileName), ConfigFileFormat.Properties)))) {
            properties = new Properties();
            try {
                properties.load(new StringReader(content));
            }
            catch (IOException e) {
                log.error((Object)("[RemoteReader] parse remote properties error, error message=" + e.getMessage()));
                return new Properties();
            }
            mergedProperties.putAll((Map<?, ?>)properties);
        } else {
            log.debug((Object)("[RemoteReader] can't find from remote - " + (String)key));
        }
        return mergedProperties;
    }

    @Override
    public String getPlatformString(String baseName, String key, Object ... patternArguments) {
        return this.getPlatformString(baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
    }

    private String getPlatformString(String baseName, Locale locale, String key, Object ... patternArguments) {
        Object fileNameWithoutExtension = baseName;
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            fileNameWithoutExtension = (String)fileNameWithoutExtension + "_" + String.valueOf(locale);
        }
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigType(ConfigType.PLATFORM);
        configInfo.setFileNameWithoutExtension((String)fileNameWithoutExtension);
        configInfo.setModifiedFileName("platform." + (String)fileNameWithoutExtension);
        Properties properties = this.getProperties(configInfo);
        if (properties.containsKey(key)) {
            String platformString = (String)properties.get(key);
            if (patternArguments != null && patternArguments.length > 0) {
                platformString = String.format(platformString, patternArguments);
            }
            return platformString;
        }
        log.debug((Object)("[RemoteReader] can't find from remote - " + key));
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            return this.getPlatformString(baseName, null, key, patternArguments);
        }
        return null;
    }

    @Override
    public String getApplicationString(String baseName, String key, Object ... patternArguments) {
        return this.getApplicationString(baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
    }

    private String getApplicationString(String baseName, Locale locale, String key, Object ... patternArguments) {
        Object fileNameWithoutExtension = baseName;
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            fileNameWithoutExtension = (String)fileNameWithoutExtension + "_" + String.valueOf(locale);
        }
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigType(ConfigType.APPLICATION);
        configInfo.setFileNameWithoutExtension((String)fileNameWithoutExtension);
        configInfo.setModifiedFileName((String)fileNameWithoutExtension);
        Properties properties = this.getProperties(configInfo);
        if (properties.containsKey(key)) {
            String applicationString = (String)properties.get(key);
            if (patternArguments != null && patternArguments.length > 0) {
                applicationString = String.format(applicationString, patternArguments);
            }
            return applicationString;
        }
        log.debug((Object)("[RemoteReader] can't find from remote - " + key));
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            return this.getApplicationString(baseName, null, key, patternArguments);
        }
        return null;
    }

    @Override
    public String getModuleString(String moduleName, String baseName, String key, Object ... patternArguments) {
        return this.getModuleString(moduleName, baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
    }

    private String getModuleString(String moduleName, String baseName, Locale locale, String key, Object ... patternArguments) {
        Object fileNameWithoutExtension = baseName;
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            fileNameWithoutExtension = (String)fileNameWithoutExtension + "_" + String.valueOf(locale);
        }
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigType(ConfigType.MODULE);
        configInfo.setFileNameWithoutExtension((String)fileNameWithoutExtension);
        configInfo.setModifiedFileName(moduleName + "." + (String)fileNameWithoutExtension);
        Properties properties = this.getProperties(configInfo);
        if (properties.containsKey(key)) {
            String moduleString = (String)properties.get(key);
            if (patternArguments != null && patternArguments.length > 0) {
                moduleString = String.format(moduleString, patternArguments);
            }
            return moduleString;
        }
        log.debug((Object)("[RemoteReader] can't find from remote - " + key));
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            return this.getModuleString(moduleName, baseName, null, key, patternArguments);
        }
        return null;
    }

    @Override
    public String getString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        if (cl.equals(DWApplicationClassLoader.getInstance().getDWPlatformClassLoader())) {
            return this.getPlatformString(baseName, locale, key, patternArguments);
        }
        if (cl.equals((Object)DWApplicationClassLoader.getInstance())) {
            return this.getApplicationString(baseName, locale, key, patternArguments);
        }
        String moduleName = DWModuleClassLoader.getModuleName(cl);
        return this.getModuleString(moduleName, baseName, locale, key, patternArguments);
    }

    private String getXmlConfigFileString(ConfigType configType, String xmlNameWithoutExtension) {
        return this.getConfigFileString(configType, xmlNameWithoutExtension, ConfigFileFormat.XML);
    }

    private String getConfigFileString(ConfigType configType, String nameWithoutExtension, ConfigFileFormat configFileFormat) {
        switch (configType) {
            case APPLICATION: 
            case MODULE: {
                ApplicationConfigFile applicationConfigFile = ApplicationConfigService.getConfigFile((String)nameWithoutExtension, (ConfigFileFormat)configFileFormat);
                return applicationConfigFile.getContent();
            }
            case PLATFORM: {
                PlatformConfigFile platformConfigFile = PlatformConfigService.getConfigFile((String)nameWithoutExtension, (ConfigFileFormat)configFileFormat);
                return platformConfigFile.getContent();
            }
        }
        return null;
    }
}

