/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.utils.DWModuleJarScanHelper;
import com.digiwin.app.module.utils.DWProfileScanHelperUtils;
import com.digiwin.app.module.utils.ModuleJarScanInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public class DWProfileJarScanHelper
extends DWModuleJarScanHelper<Map<String, List<Class<?>>>> {
    private ModuleJarScanInfo moduleJarScanInfo = new ModuleJarScanInfo();

    public DWProfileJarScanHelper(List<String> platformModulePaths, List<String> applicationModulePaths) {
        super(platformModulePaths, applicationModulePaths);
    }

    @Override
    protected void onJarScan(String moduleName, JarFile jarFile, DWModuleClassLoader classLoader, Map<String, List<Class<?>>> scanContext) {
        super.onJarScan(moduleName, jarFile, classLoader, scanContext);
        String jarName = jarFile.getName();
        boolean isPrimaryJar = this.moduleJarScanInfo.isPrimaryJar(moduleName, jarName);
        if (isPrimaryJar) {
            List<String> classNameList = this.moduleJarScanInfo.getClassNameList(moduleName, jarName);
            for (String className : classNameList) {
                classLoader.addServiceInfo(className);
            }
        }
    }

    @Override
    protected void onClassScan(String moduleName, DWModuleClassLoader classLoader, String jarName, Class<?> clazz, Map<String, List<Class<?>>> scanContext) {
        DWProfileScanHelperUtils.onClassScan(moduleName, classLoader, jarName, clazz, scanContext, this.moduleJarScanInfo);
    }

    @Override
    protected Map<String, List<Class<?>>> createScanContext() {
        this.moduleJarScanInfo.clear();
        return new HashMap();
    }
}

