/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;

public class DWServiceContext
implements Serializable {
    private static ThreadLocal<DWServiceContext> currentContext = new ThreadLocal();
    private String uuid = null;
    private Map<String, Object> profile = null;
    @Deprecated
    private String moduleName = null;
    private String groupName = null;
    private List<Long> durations = new ArrayList<Long>();
    private boolean async = false;
    private transient Future<?> future = null;
    private String token = null;
    private Map<String, Object> requestHeader = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private String requestBody = null;
    private Map<String, Object> responseHeader = new HashMap<String, Object>();
    private int statusCode = 200;
    private boolean standardResult = true;
    private boolean disableResultHandler = true;
    private String traceId;
    private String requestURI;
    private String digiServiceName = null;
    protected boolean allowCrossTenant = false;
    private Map<String, Object> operateLog = new HashMap<String, Object>();
    private Map<String, Object> data = new HashMap<String, Object>();
    private transient Map<String, Object> nonSerializableData = new HashMap<String, Object>();

    public static DWServiceContext getContext() {
        DWServiceContext context = currentContext.get();
        if (context == null) {
            context = new DWServiceContext();
            currentContext.set(context);
        }
        return context;
    }

    public static void setContext(DWServiceContext serviceContext) {
        currentContext.set(serviceContext);
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public Map<String, Object> getProfile() {
        return this.profile;
    }

    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public long getDuration() {
        if (this.durations != null && !this.durations.isEmpty()) {
            return this.durations.get(this.durations.size() - 1);
        }
        return 0L;
    }

    public List<Long> getDurations() {
        return Collections.unmodifiableList(this.durations);
    }

    public void pushDuration(long duration) {
        this.durations.add(duration);
    }

    @Deprecated
    public String getModuleName() {
        return this.moduleName;
    }

    @Deprecated
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setFuture(Future<?> future) {
        this.future = future;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Map<String, Object> getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(Map<String, Object> requestHeader) {
        this.requestHeader = requestHeader;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public Map<String, Object> getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(Map<String, Object> responseHeader) {
        this.responseHeader = responseHeader;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public boolean getStandardResult() {
        return this.standardResult;
    }

    public void setStandardResult(boolean standardResult) {
        this.standardResult = standardResult;
    }

    public boolean getResultHandlerEnabled() {
        return this.disableResultHandler;
    }

    public void disableResultHandler() {
        this.disableResultHandler = false;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getDigiServiceName() {
        return this.digiServiceName;
    }

    public void setDigiServiceName(String digiServiceName) {
        this.digiServiceName = digiServiceName;
    }

    public boolean getAllowCrossTenant() {
        return this.allowCrossTenant;
    }

    public void setAllowCrossTenant(boolean allowCrossTenant) {
        this.allowCrossTenant = allowCrossTenant;
    }

    public Map<String, Object> getOperateLog() {
        return this.operateLog;
    }

    public void setOperateLog(Map<String, Object> operateLog) {
        this.operateLog = operateLog;
    }

    public void set(String key, Object value) {
        if (value == null || value instanceof Serializable) {
            this.nonSerializableData.remove(key);
            this.data.put(key, value);
        } else {
            this.data.remove(key);
            this.nonSerializableData.put(key, value);
        }
    }

    public <T> T get(String key, T defaultValue) {
        if (this.nonSerializableData.containsKey(key)) {
            return (T)this.nonSerializableData.get(key);
        }
        Object value = this.data.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public <T> T get(String key) {
        if (this.nonSerializableData.containsKey(key)) {
            return (T)this.nonSerializableData.get(key);
        }
        return (T)this.data.get(key);
    }

    public Object remove(String key) {
        if (this.data.containsKey(key)) {
            return this.data.remove(key);
        }
        if (this.nonSerializableData.containsKey(key)) {
            return this.nonSerializableData.remove(key);
        }
        return null;
    }

    public void remove() {
        currentContext.remove();
    }

    @Deprecated
    public void clear() {
        this.uuid = null;
        this.moduleName = null;
        this.profile = null;
        this.durations.clear();
        this.async = false;
        this.future = null;
        this.token = null;
        this.requestHeader = new HashMap<String, Object>();
        this.requestBody = null;
        this.responseHeader = new HashMap<String, Object>();
        this.statusCode = 200;
        this.standardResult = true;
        this.disableResultHandler = true;
        this.traceId = null;
        this.requestURI = null;
        this.digiServiceName = null;
        this.operateLog = new HashMap<String, Object>();
        this.data = new HashMap<String, Object>();
        this.nonSerializableData = new HashMap<String, Object>();
    }

    public DWServiceContext deepClone() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ObjectOutputStream objOutput = new ObjectOutputStream(output);
        objOutput.writeObject(this);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        ObjectInputStream objInput = new ObjectInputStream(input);
        DWServiceContext clonedContext = (DWServiceContext)objInput.readObject();
        clonedContext.nonSerializableData = new HashMap<String, Object>(this.nonSerializableData);
        return clonedContext;
    }

    public static void main(String[] params) throws Exception {
        Method method = DWServiceContext.class.getDeclaredMethod("deepClone", new Class[0]);
        DWServiceContext.getContext().set("test", method);
        DWServiceContext cloneContext = DWServiceContext.getContext().deepClone();
        System.out.println("test = " + String.valueOf(cloneContext.get("test")));
        System.out.println("done!");
    }
}

