/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor.log;

import com.digiwin.app.service.interceptor.log.DWRedisLogMehodInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DWMongoTemplateInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DWRedisLogMehodInterceptor.class);
    private Environment environment;

    public DWMongoTemplateInterceptor(Environment environment) {
        this.environment = environment;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String methodName;
        ThreadContext.put((String)"nodeType", (String)"MongoDB");
        ThreadContext.put((String)"paramSize", (String)"");
        ThreadContext.put((String)"timeConsume", (String)"");
        String nodeId = methodName = methodInvocation.getMethod().getName();
        ThreadContext.put((String)"type", (String)"mongdb-req");
        ThreadContext.put((String)"nodeId", (String)nodeId);
        logger.info("execute " + nodeId);
        long startTime = System.currentTimeMillis();
        Object result = methodInvocation.proceed();
        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;
        ThreadContext.put((String)"type", (String)"mongdb-resp");
        ThreadContext.put((String)"timeConsume", (String)String.valueOf(executionTime));
        String console = this.environment.getProperty("dw.log.mongdb.param-console.enable", "false");
        if ("true".equals(console)) {
            logger.info("{}", result);
        } else {
            logger.info("");
        }
        return result;
    }
}

