/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.processor;

import com.digiwin.app.service.processor.DWInvokerBeanProcessor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class DWInvokerBeanContainerBeanProcessor
implements BeanPostProcessor {
    private static Log log = LogFactory.getLog(DWInvokerBeanContainerBeanProcessor.class);
    private List<DWInvokerBeanProcessor> targetProcessors = new ArrayList<DWInvokerBeanProcessor>();

    public void registerProcessor(DWInvokerBeanProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor is null!");
        }
        this.targetProcessors.add(processor);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object targetProcessor = null;
        try {
            for (DWInvokerBeanProcessor innerProcessor : this.targetProcessors) {
                if (!innerProcessor.accept(bean)) continue;
                targetProcessor = innerProcessor;
                targetProcessor.process(bean, beanName);
            }
        }
        catch (Exception e) {
            String type = targetProcessor == null ? "" : targetProcessor.getClass().getName();
            log.error((Object)String.format("Service Chain DWInvokerBeanDefaultProcessor failed! type=%s, beanName=%s", type, beanName), (Throwable)e);
        }
        return bean;
    }

    @Deprecated
    public static <T> List<T> getFieldListValue(Object bean, String fieldName, Class<? extends T> processorType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        return DWInvokerBeanContainerBeanProcessor.getFieldListValueCore(bean, fieldName, processorType::isInstance, () -> {
            try {
                return processorType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <T> List<T> addValueIfNecessary(Supplier<List<T>> sourceList, Class<? extends T> processorType, Consumer<List<T>> updater) throws IllegalAccessException, InstantiationException {
        boolean isProcessorExist;
        List<T> value = sourceList.get();
        if (value == null) {
            value = new ArrayList<T>();
        }
        if (isProcessorExist = value.stream().anyMatch(processorType::isInstance)) {
            return null;
        }
        value.add(processorType.newInstance());
        updater.accept(value);
        return value;
    }

    public static <T> T[] addValueIfNecessary(Supplier<Collection<T>> sourceCollectionSupplier, Class<T> collectionItemBaseType, Supplier<? extends T> newValueSupplier, Consumer<T[]> updater) throws IllegalAccessException, InstantiationException {
        Collection<Object> valueCollection = sourceCollectionSupplier.get();
        if (valueCollection == null) {
            valueCollection = new ArrayList<T>();
        }
        T newValue = newValueSupplier.get();
        boolean newValueExists = valueCollection.stream().anyMatch(newValue.getClass()::isInstance);
        if (newValueExists) {
            return null;
        }
        valueCollection.add(newValue);
        Object[] valueArray = valueCollection.toArray((Object[])Array.newInstance(collectionItemBaseType, valueCollection.size()));
        updater.accept(valueArray);
        return valueArray;
    }

    @Deprecated
    public static <T> T[] getFieldArrayValue(Object bean, String fieldName, Class<T> baseClass, Class<? extends T> processorType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        List<Object> value = DWInvokerBeanContainerBeanProcessor.getFieldListValue(bean, fieldName, processorType);
        return value == null ? null : value.toArray((Object[])Array.newInstance(baseClass, value.size()));
    }

    public static <T> T[] getFieldArrayValueWithNecessaryInstance(Object bean, String fieldName, Class<T> baseClass, T instance) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        List<Object> value = DWInvokerBeanContainerBeanProcessor.getFieldListValueCore(bean, fieldName, instance.getClass()::isInstance, () -> instance);
        return value == null ? null : value.toArray((Object[])Array.newInstance(baseClass, value.size()));
    }

    private static <T> List<T> getFieldListValueCore(Object bean, String fieldName, Predicate<? super T> anyMatchPredicate, Supplier<T> instanceSupplier) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        if (AopUtils.isAopProxy((Object)bean)) {
            bean = AopProxyUtils.getSingletonTarget((Object)bean);
        }
        boolean isProcessorExist = false;
        Field processorsField = ReflectionUtils.findField(bean.getClass(), (String)fieldName);
        processorsField.setAccessible(true);
        Object sourceValue = processorsField.get(bean);
        ArrayList<Object> value = sourceValue != null && sourceValue.getClass().isArray() ? new ArrayList<Object>(Arrays.asList((Object[])sourceValue)) : (ArrayList<Object>)sourceValue;
        processorsField.setAccessible(false);
        if (value == null) {
            value = new ArrayList();
        } else {
            isProcessorExist = value.stream().anyMatch(anyMatchPredicate);
        }
        if (isProcessorExist) {
            return null;
        }
        value.add(instanceSupplier.get());
        return value;
    }
}

