/*
 * Decompiled with CFR 0.152.
 */
package dap.framework.service.component.serviceclient;

import com.dap.component.serviceclient.api.ServiceClientConfigProvider;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.serviceclient.TenantAdminServiceClient;
import com.digiwin.app.serviceclient.util.ServiceClientUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DapServiceClientConfigProvider
implements ServiceClientConfigProvider {
    private static Log log = LogFactory.getLog(TenantAdminServiceClient.class);
    private static final String TAG = "[TenantAdminServiceClient] ";

    public String getIamApSecret(String defaultValue) {
        String iamApSecret = DWApplicationConfigUtils.getProperty((String)"iamApSecret", (String)defaultValue);
        return iamApSecret;
    }

    public String getIamApToken() {
        String appToken = DWApplicationConfigUtils.getProperty((String)"iamApToken");
        return appToken;
    }

    public String getLmcUrl() {
        String appToken = DWApplicationConfigUtils.getProperty((String)"iamApToken");
        return appToken;
    }

    public String getConnAuthKey() throws Exception {
        String connAuthKeyPath = null;
        try {
            connAuthKeyPath = DWPathUtils.getConnAuthKeyPath();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace((Log)log, (Throwable)e);
            throw e;
        }
        String encodedConnAuthKey = null;
        try {
            encodedConnAuthKey = new String(Files.readAllBytes(Paths.get(connAuthKeyPath, new String[0])));
        }
        catch (IOException e) {
            ServiceClientUtil.logStackTrace((Log)log, (Throwable)e);
            throw e;
        }
        if (StringUtils.isBlank((CharSequence)encodedConnAuthKey)) {
            log.error((Object)"[TenantAdminServiceClient] no ConnAuthKey");
            throw new Exception("no ConnAuthKey");
        }
        byte[] base64decodedBytes = Base64.getDecoder().decode(encodedConnAuthKey);
        String connAuthKey = new String(base64decodedBytes, StandardCharsets.UTF_8);
        return connAuthKey;
    }
}

