/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceRepository;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWServiceRepositoryList
implements DWServiceRepository {
    private List<DWServiceRepository> serviceRepositoryList = new ArrayList<DWServiceRepository>();

    public void setRepositories(List<DWServiceRepository> repositories) {
        this.serviceRepositoryList = repositories;
    }

    public void addRepository(DWServiceRepository serviceRepository) {
        if (serviceRepository == null) {
            throw new IllegalArgumentException();
        }
        this.serviceRepositoryList.add(serviceRepository);
    }

    @Override
    public DWService getService(DWHeader header, DWMethod method) throws Exception {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        for (DWServiceRepository serviceRepository : this.serviceRepositoryList) {
            DWService service = serviceRepository.getService(header, method);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    @Override
    public Map<String, List<DWServiceInfo>> getServiceInfos() {
        HashMap<String, List<DWServiceInfo>> serviceInfos = new HashMap<String, List<DWServiceInfo>>();
        for (DWServiceRepository sr : this.serviceRepositoryList) {
            Map<String, List<DWServiceInfo>> groupServiceInfoMap = sr.getServiceInfos();
            for (Map.Entry<String, List<DWServiceInfo>> item : groupServiceInfoMap.entrySet()) {
                ArrayList mergedServiceInfoList = (ArrayList)serviceInfos.get(item.getKey());
                if (mergedServiceInfoList == null) {
                    mergedServiceInfoList = new ArrayList();
                    serviceInfos.put(item.getKey(), mergedServiceInfoList);
                }
                mergedServiceInfoList.addAll(item.getValue());
            }
        }
        return serviceInfos;
    }

    @Override
    public List<DWServiceInfo> getServiceInfos(String groupName) {
        ArrayList<DWServiceInfo> serviceInfos = new ArrayList<DWServiceInfo>();
        for (DWServiceRepository sr : this.serviceRepositoryList) {
            serviceInfos.addAll(sr.getServiceInfos(groupName));
        }
        return serviceInfos;
    }

    @Override
    public DWServiceInfo getServiceInfo(String groupName, String serviceName) {
        return null;
    }

    @Override
    public void refresh(String moduleName) throws Exception {
        for (DWServiceRepository serviceRepository : this.serviceRepositoryList) {
            serviceRepository.refresh(moduleName);
        }
    }
}

