/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.developer;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.local.developer.definer.DWDeveloperHeaderDefiner;
import com.digiwin.app.service.DWServiceLocationInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDeveloperHeaderRepository
implements DWHeaderRepository {
    static Log log = LogFactory.getLog(DWDeveloperHeaderRepository.class);
    protected List<DWHeader> headers;

    public DWDeveloperHeaderRepository() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<DWHeader> getAllHeader() {
        return this.headers;
    }

    private void initialize() throws Exception {
        this.headers = new ArrayList<DWHeader>();
        DWDeveloperHeaderDefiner definer = new DWDeveloperHeaderDefiner();
        List<DWHeader> developerHeaders = definer.getDeveloperHeaders();
        this.headers.addAll(developerHeaders);
        this.log();
    }

    private void log() {
        StringBuilder message = new StringBuilder();
        int i = 0;
        for (DWHeader header : this.headers) {
            message.setLength(0);
            message.append(">>> Found Developer Header ").append(++i).append(".");
            message.append("module=").append(header.getModuleName());
            message.append(", service name=").append(header.getServiceName());
            message.append(", type=").append(header.getServiceType().getName());
            log.info((Object)message.toString());
        }
    }

    @Override
    public void refresh(String moduleName) throws Exception {
        this.initialize();
    }

    @Override
    public List<DWHeader> getHeaders(String moduleName) {
        ArrayList<DWHeader> result = new ArrayList<DWHeader>();
        for (DWHeader header : this.headers) {
            if (!StringUtils.equals((CharSequence)header.getModuleName(), (CharSequence)moduleName)) continue;
            result.add(header);
        }
        return result;
    }

    @Override
    public DWHeader getHeader(String groupName, String serviceName) {
        return null;
    }

    @Override
    public DWTargetAPI getAPI(DWServiceLocationInfo locationInfo) {
        return null;
    }
}

