/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local;

import com.digiwin.app.container.DWAbstractHeaderRepository;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWMethodMatchProcessor;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWSimpleServiceLocationInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWLocalHeaderRepository
extends DWAbstractHeaderRepository<DWHeader, DWSimpleServiceLocationInfo> {
    private Map<DWHeader, Map<String, List<DWMethod>>> methodMap = new HashMap<DWHeader, Map<String, List<DWMethod>>>();

    @Override
    protected void afterRegister(String groupName, List<DWHeader> headers, List<DWHeader> oldHeaders) {
        this.createMethodMap(groupName, headers);
    }

    private void createMethodMap(String groupName, List<DWHeader> headers) {
        this.methodMap.entrySet().removeIf(item -> groupName.equals(((DWHeader)item.getKey()).getModuleName()));
        headers.forEach(header -> this.methodMap.put((DWHeader)header, header.getDWMethods()));
    }

    @Override
    protected DWTargetAPI searchAPI(DWSimpleServiceLocationInfo locationInfo) {
        DWHeader header = this.getHeaders(locationInfo.getGroup()).stream().filter(h -> h.getServiceName().equals(locationInfo.getServiceName())).findFirst().orElse(null);
        if (header == null) {
            return DWTargetAPI.createInvalidAPI();
        }
        DWMethod method = null;
        Map<String, List<DWMethod>> methodMaps = this.methodMap.get(header);
        if (methodMaps != null) {
            for (DWMethodMatchProcessor matchProcessor : this.matchProcessors) {
                matchProcessor.process(methodMaps, locationInfo);
                List<DWMethod> methodList = methodMaps.get(locationInfo.getMethodName());
                if (methodList == null || (method = (DWMethod)methodList.stream().filter(m -> m.isMatch(locationInfo.getParameters())).findFirst().orElse(null)) == null) continue;
                break;
            }
        }
        return new DWTargetAPI(header, method);
    }
}

