/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.validation;

import com.digiwin.app.common.config.ConfigPool;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.hibernate.validator.resourceloading.AggregateResourceBundleLocator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

public class DWResourceBundleLocator
implements ResourceBundleLocator {
    private PlatformResourceBundleLocator hibernateRbLocator = new PlatformResourceBundleLocator("org.hibernate.validator.ValidationMessages");

    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = this.hibernateRbLocator.getResourceBundle(locale);
        Properties applicationI18nProperties = ConfigPool.getInstance().getApplicationI18nProperties("message", locale);
        DWPropertyResourceBundle applicationRb = new DWPropertyResourceBundle(applicationI18nProperties);
        List<ResourceBundle> rsList = Arrays.asList(applicationRb, rb);
        return new AggregateResourceBundleLocator.AggregateBundle(rsList);
    }

    public static class DWPropertyResourceBundle
    extends ResourceBundle {
        private Map<String, Object> lookup;

        public DWPropertyResourceBundle(Properties source) {
            this.lookup = new HashMap<Object, Object>(source);
        }

        @Override
        public Object handleGetObject(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.lookup.get(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            final ResourceBundle parent = this.parent;
            return new Enumeration<String>(){
                Set<String> set;
                Iterator<String> iterator;
                Enumeration<String> enumeration;
                String next;
                {
                    this.set = lookup.keySet();
                    this.iterator = lookup.keySet().iterator();
                    this.enumeration = parent != null ? parent.getKeys() : null;
                    this.next = null;
                }

                @Override
                public boolean hasMoreElements() {
                    if (this.next == null) {
                        if (this.iterator.hasNext()) {
                            this.next = this.iterator.next();
                        } else if (this.enumeration != null) {
                            while (this.next == null && this.enumeration.hasMoreElements()) {
                                this.next = this.enumeration.nextElement();
                                if (!this.set.contains(this.next)) continue;
                                this.next = null;
                            }
                        }
                    }
                    return this.next != null;
                }

                @Override
                public String nextElement() {
                    if (this.hasMoreElements()) {
                        String result = this.next;
                        this.next = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        protected Set<String> handleKeySet() {
            return this.lookup.keySet();
        }
    }
}

