/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.ConfigPool;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DWPropertiesUtils {
    private static ConfigPool pool = ConfigPool.getInstance();

    DWPropertiesUtils() {
    }

    public static Properties getProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    public static Properties getProperties(String path, String propertiesName) {
        return pool.getProperties(path, propertiesName);
    }

    public static String getProperty(String path, String propertiesName, String key) {
        return DWPropertiesUtils.getProperty(path, propertiesName, key, null);
    }

    public static String getProperty(String path, String propertiesName, String key, String defaultValue) {
        String result = defaultValue;
        Properties properties = DWPropertiesUtils.getProperties(path, propertiesName);
        if (properties != null && properties.containsKey(key)) {
            result = properties.getProperty(key);
        }
        return result;
    }

    public static Properties getPlatformProperties(String propertiesName) {
        String path = DWPathUtils.getPlatformConfPath();
        return DWPropertiesUtils.getProperties(path, propertiesName);
    }

    public static String getPlatformProperty(String propertiesName, String key) {
        return DWPropertiesUtils.getPlatformProperty(propertiesName, key, null);
    }

    public static String getPlatformProperty(String propertiesName, String key, String defaultValue) {
        String path = DWPathUtils.getPlatformConfPath();
        return DWPropertiesUtils.getProperty(path, propertiesName, key, defaultValue);
    }

    public static Properties getPlatformModuleProperties(String propertiesName, String moduleName) {
        String path = DWPathUtils.getPlatformModuleConfPath((String)moduleName);
        return DWPropertiesUtils.getProperties(path, propertiesName);
    }

    public static String getPlatformModuleProperty(String propertiesName, String moduleName, String key) {
        return DWPropertiesUtils.getPlatformModuleProperty(propertiesName, moduleName, key, null);
    }

    public static String getPlatformModuleProperty(String propertiesName, String moduleName, String key, String defaultValue) {
        String path = DWPathUtils.getPlatformModuleConfPath((String)moduleName);
        return DWPropertiesUtils.getProperty(path, propertiesName, key, defaultValue);
    }

    public static Properties getApplicationProperties(String propertiesName) {
        String path = DWPathUtils.getApplicationConfPath();
        return DWPropertiesUtils.getProperties(path, propertiesName);
    }

    public static String getApplicationProperty(String propertiesName, String key) {
        return DWPropertiesUtils.getApplicationProperty(propertiesName, key, null);
    }

    public static String getApplicationProperty(String propertiesName, String key, String defaultValue) {
        String path = DWPathUtils.getApplicationConfPath();
        return DWPropertiesUtils.getProperty(path, propertiesName, key, defaultValue);
    }

    public static Properties getApplicationModuleProperties(String propertiesName, String moduleName) {
        String path = DWPathUtils.getApplicationModuleConfPath((String)moduleName);
        return DWPropertiesUtils.getProperties(path, propertiesName);
    }

    public static String getApplicationModuleProperty(String propertiesName, String moduleName, String key) {
        return DWPropertiesUtils.getApplicationModuleProperty(propertiesName, moduleName, key, null);
    }

    public static String getApplicationModuleProperty(String propertiesName, String moduleName, String key, String defaultValue) {
        String path = DWPathUtils.getApplicationModuleConfPath((String)moduleName);
        return DWPropertiesUtils.getProperty(path, propertiesName, key, defaultValue);
    }

    public static Properties getIndustryProperties(String propertiesName) {
        String path = DWPathUtils.getIndustryConfPath();
        return DWPropertiesUtils.getProperties(path, propertiesName);
    }

    public static String getIndustryProperty(String propertiesName, String key) {
        return DWPropertiesUtils.getIndustryProperty(propertiesName, key, null);
    }

    public static String getIndustryProperty(String propertiesName, String key, String defaultValue) {
        String path = DWPathUtils.getIndustryConfPath();
        return DWPropertiesUtils.getProperty(path, propertiesName, key, defaultValue);
    }

    public static Properties getIndustryModuleProperties(String propertiesName, String moduleName) {
        String path = DWPathUtils.getIndustryModuleConfPath((String)moduleName);
        return DWPropertiesUtils.getProperties(path, propertiesName);
    }

    public static String getIndustryModuleProperty(String propertiesName, String moduleName, String key) {
        return DWPropertiesUtils.getIndustryModuleProperty(propertiesName, moduleName, key, null);
    }

    public static String getIndustryModuleProperty(String propertiesName, String moduleName, String key, String defaultValue) {
        String path = DWPathUtils.getIndustryModuleConfPath((String)moduleName);
        return DWPropertiesUtils.getProperty(path, propertiesName, key, defaultValue);
    }

    public static Properties getCustomizationProperties(String propertiesName) {
        String path = DWPathUtils.getCustomizationConfPath();
        return DWPropertiesUtils.getProperties(path, propertiesName);
    }

    public static String getCustomizationProperty(String propertiesName, String key) {
        return DWPropertiesUtils.getCustomizationProperty(propertiesName, key, null);
    }

    public static String getCustomizationProperty(String propertiesName, String key, String defaultValue) {
        String path = DWPathUtils.getCustomizationConfPath();
        return DWPropertiesUtils.getProperty(path, propertiesName, key, defaultValue);
    }

    public static Properties getCustomizationModuleProperties(String propertiesName, String moduleName) {
        String path = DWPathUtils.getCustomizationModuleConfPath((String)moduleName);
        return DWPropertiesUtils.getProperties(path, propertiesName);
    }

    public static String getCustomizationModuleProperty(String propertiesName, String moduleName, String key) {
        return DWPropertiesUtils.getCustomizationModuleProperty(propertiesName, moduleName, key, null);
    }

    public static String getCustomizationModuleProperty(String propertiesName, String moduleName, String key, String defaultValue) {
        String path = DWPathUtils.getCustomizationModuleConfPath((String)moduleName);
        return DWPropertiesUtils.getProperty(path, propertiesName, key, defaultValue);
    }
}

