/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.spring;

import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.service.DWAbstractApplicationContextServiceBuilder;
import com.digiwin.app.service.DWServiceBeanNameGenerator;
import org.springframework.context.ApplicationContext;

public class DWSpringServiceBuilder
extends DWAbstractApplicationContextServiceBuilder {
    public DWSpringServiceBuilder(DWServiceBeanNameGenerator beanNameGenerator) {
        super(beanNameGenerator);
    }

    public DWSpringServiceBuilder(boolean useTypeBasedBeanLookup, DWServiceBeanNameGenerator beanNameGenerator) {
        super(useTypeBasedBeanLookup, beanNameGenerator);
    }

    @Override
    protected ApplicationContext getApplicationContext(Object service, String groupName) {
        ApplicationContext context = DWModuleSpringUtils.getModuleSpringContext(groupName);
        if (context == null) {
            context = DWApplicationSpringUtils.getContext();
        }
        return context;
    }

    public Object build(Object service) throws Exception {
        if (service == null) {
            return null;
        }
        String moduleName = this.getModuleName(service);
        return this.build(service, moduleName);
    }

    private String getModuleName(Object service) {
        ClassLoader classLoader = null;
        classLoader = service instanceof Class ? ((Class)service).getClassLoader() : service.getClass().getClassLoader();
        String moduleName = DWModuleClassLoader.getModuleName(classLoader);
        return moduleName;
    }
}

