/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.http;

import com.digiwin.app.http.HttpRequestModel;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;

public class HttpConnectionManager {
    public static CloseableHttpClient httpClient;

    public static synchronized void init(HttpRequestModel requestModel) {
        if (httpClient == null) {
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout((long)requestModel.getConnectionTimeout(), TimeUnit.SECONDS).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(requestModel.getMaxTotalConnections());
            connectionManager.setMaxTotal(requestModel.getMaxTotalConnections());
            connectionManager.setDefaultConnectionConfig(connectionConfig);
            RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout((long)requestModel.getSoTimeout(), TimeUnit.SECONDS).setConnectionRequestTimeout((long)requestModel.getConnectionPoolRequestTimeout(), TimeUnit.SECONDS).build();
            httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
    }

    public static CloseableHttpClient getHttpClient(HttpRequestModel requestModel) {
        if (httpClient == null) {
            HttpConnectionManager.init(requestModel);
        }
        return httpClient;
    }
}

