/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.spring.scanner;

import com.digiwin.app.module.spring.scanner.SpringConfigScanner;
import com.digiwin.app.module.utils.DWDeveloperServiceCSVReader;
import com.digiwin.app.module.utils.DWDeveloperServicePathManager;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.springframework.util.StringUtils;

public class DWDeveloperSpringConfigScanner
implements SpringConfigScanner {
    private List<CSVRecord> csvRecords;

    public DWDeveloperSpringConfigScanner() {
        DWDeveloperServiceCSVReader reader = new DWDeveloperServiceCSVReader();
        this.csvRecords = reader.getCSVRecords();
    }

    @Override
    public Map<String, String[]> doScan() {
        HashMap<String, String[]> moduleSpringConfig = new HashMap<String, String[]>();
        try {
            for (CSVRecord record : this.csvRecords) {
                String springConfigFileName;
                if (!Boolean.valueOf(record.get("isAvailable")).booleanValue()) continue;
                String moduleName = record.get("moduleName");
                String implementPath = record.get("implementPath");
                DWDeveloperServicePathManager pathManager = new DWDeveloperServicePathManager(implementPath);
                Properties moduleProperties = new Properties();
                String propertiesName = moduleName + ".properties";
                File[] projectFiles = new File(pathManager.getProjectPath()).listFiles();
                if (projectFiles == null) {
                    throw new NoSuchFileException(System.getProperty("line.separator") + "\u8acb\u6aa2\u67e5developer-service.csv\u3001Java Build Path\u548cDeployment Assembly" + System.getProperty("line.separator") + "\u672a\u767c\u73fe\u958b\u767c\u8005\u670d\u52d9\u5c08\u6848\u8cc7\u6599\u593e - " + implementPath.replace(File.separator, "."));
                }
                for (File projectFile : projectFiles) {
                    if (!propertiesName.equals(projectFile.getName())) continue;
                    try {
                        moduleProperties.load(new FileInputStream(projectFile.getAbsolutePath()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ArrayList<CallSite> fileNames = new ArrayList<CallSite>();
                if (!moduleProperties.isEmpty() && !StringUtils.isEmpty((Object)(springConfigFileName = moduleProperties.getProperty("springconfigfilename")))) {
                    String[] springConfigFileNames;
                    for (String fileName : springConfigFileNames = springConfigFileName.split(",")) {
                        String configPath = "file:" + File.separator + pathManager.getProjectPath() + File.separator + fileName;
                        fileNames.add((CallSite)((Object)configPath));
                    }
                }
                if (fileNames.isEmpty()) {
                    for (File projectFile : projectFiles) {
                        if (!"spring-config.xml".equals(projectFile.getName())) continue;
                        String configPath = "file:" + File.separator + pathManager.getProjectPath() + File.separator + projectFile.getName();
                        fileNames.add((CallSite)((Object)configPath));
                    }
                }
                moduleSpringConfig.put(moduleName, fileNames.toArray(new String[fileNames.size()]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return moduleSpringConfig;
    }

    @Override
    public Map<String, String[]> doScan(String moduleName) {
        return new HashMap<String, String[]>();
    }
}

