/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import com.digiwin.app.service.DWServiceBeanNameGenerator;
import com.digiwin.app.service.DWServiceBuilder;
import java.util.Objects;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public abstract class DWAbstractApplicationContextServiceBuilder
implements DWServiceBuilder {
    private boolean useTypeBasedBeanLookup = false;
    private DWServiceBeanNameGenerator beanNameGenerator;

    public DWAbstractApplicationContextServiceBuilder(DWServiceBeanNameGenerator beanNameGenerator) {
        this(false, beanNameGenerator);
    }

    public DWAbstractApplicationContextServiceBuilder(boolean useTypeBasedBeanLookup, DWServiceBeanNameGenerator beanNameGenerator) {
        Objects.requireNonNull(beanNameGenerator);
        this.beanNameGenerator = beanNameGenerator;
        this.useTypeBasedBeanLookup = useTypeBasedBeanLookup;
    }

    protected abstract ApplicationContext getApplicationContext(Object var1, String var2);

    @Override
    public Object build(Object service, String groupName) throws Exception {
        if (service == null) {
            return null;
        }
        ApplicationContext context = this.getApplicationContext(service, groupName);
        if (context != null) {
            String beanId = this.beanNameGenerator.generateBeanName(service, groupName);
            if (this.useTypeBasedBeanLookup) {
                Class<?> clazz = service instanceof Class ? (Class<?>)service : service.getClass();
                Object springBean = null;
                try {
                    springBean = context.getBean(clazz);
                    return springBean;
                }
                catch (NoUniqueBeanDefinitionException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
            } else if (context.containsBean(beanId)) {
                return context.getBean(beanId);
            }
            service = this.createInstance(service);
            context.getAutowireCapableBeanFactory().autowireBean(service);
            Object springBean = context.getAutowireCapableBeanFactory().applyBeanPostProcessorsAfterInitialization(service, beanId);
            return springBean;
        }
        service = this.createInstance(service);
        return service;
    }

    protected Object createInstance(Object service) throws Exception {
        if (service instanceof Class) {
            return ((Class)service).newInstance();
        }
        return service;
    }
}

