/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai.serviceinstance;

import com.digiwin.app.eai.serviceinstance.ServiceInstanceVo;
import com.digiwin.app.eai.util.InstanceUtil;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ServiceInstanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceInstanceService.class);
    private static final String MONGO_DB_COLLECTION_NAME = "dw_service_instance_state";
    private MongoClient mongoClient;
    private Environment environment;
    private String appId;
    private int reportFrequency;

    public ServiceInstanceService(Environment environment, MongoClient mongoClient) {
        this.environment = environment;
        this.appId = this.appId = environment.getProperty("appId");
        this.reportFrequency = Integer.parseInt(environment.getProperty("dap.eai.service-instance.report.frequency", "60000"));
        this.mongoClient = mongoClient;
    }

    public void startUp() {
        ServiceInstanceThread serviceInstanceThread = new ServiceInstanceThread(this, "dap-eai-service-instance");
        serviceInstanceThread.start();
    }

    public void report() {
        LOGGER.debug("ServiceInstanceService report...");
        LOGGER.debug("appId=" + this.appId);
        String instanceName = InstanceUtil.getInstanceName();
        LOGGER.debug("instanceName=" + instanceName);
        String groupName = this.parseGroupName(instanceName);
        LOGGER.debug("groupName=" + groupName);
        Date checkTime = new Date();
        LOGGER.debug("checkTime=" + checkTime);
        this.persistentServiceInstance(this.appId, instanceName, groupName, checkTime);
    }

    private void persistentServiceInstance(String appId, String instanceName, String groupName, Date checkTime) {
        MongoCollection<Document> collection = this.getCollection();
        Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"appId", (Object)appId), Filters.eq((String)"instanceName", (Object)instanceName)});
        long count = collection.count(Filters.and((Bson[])new Bson[]{Filters.eq((String)"appId", (Object)appId), Filters.eq((String)"instanceName", (Object)instanceName)}));
        if (count > 0L) {
            Bson update = Updates.set((String)"checkTime", (Object)checkTime);
            collection.updateOne(condition, update);
        } else {
            Document document = new Document("appId", (Object)appId).append("instanceName", (Object)instanceName).append("groupName", (Object)groupName).append("checkTime", (Object)checkTime);
            collection.insertOne((Object)document);
        }
    }

    public List<ServiceInstanceVo> getServiceInstances() {
        MongoCollection<Document> collection = this.getCollection();
        Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"appId", (Object)this.appId)});
        FindIterable findIterable = collection.find(condition);
        MongoCursor mongoCursor = findIterable.iterator();
        ArrayList<ServiceInstanceVo> serviceInstanceVos = new ArrayList<ServiceInstanceVo>();
        while (mongoCursor.hasNext()) {
            ServiceInstanceVo serviceInstanceVo = new ServiceInstanceVo();
            Document document = (Document)mongoCursor.next();
            serviceInstanceVo.setAppId(document.getString((Object)"appId"));
            serviceInstanceVo.setInstanceName(document.getString((Object)"instanceName"));
            serviceInstanceVo.setGroupName(document.getString((Object)"groupName"));
            serviceInstanceVo.setCheckTime(document.getDate((Object)"checkTime"));
            serviceInstanceVos.add(serviceInstanceVo);
        }
        return serviceInstanceVos;
    }

    public void deleteServiceInstance(String appId, String instanceName) {
        MongoCollection<Document> collection = this.getCollection();
        Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"appId", (Object)appId), Filters.eq((String)"instanceName", (Object)instanceName)});
        collection.deleteOne(condition);
    }

    private MongoDatabase getMongoDatabase() {
        String databaseName = this.environment.getProperty("fasyncMongoDatabaseName");
        MongoDatabase database = this.mongoClient.getDatabase(databaseName);
        return database;
    }

    private MongoCollection<Document> getCollection() {
        MongoDatabase database = this.getMongoDatabase();
        List collectionNameList = (List)database.listCollectionNames().into(new ArrayList());
        if (!collectionNameList.contains(MONGO_DB_COLLECTION_NAME)) {
            database.createCollection(MONGO_DB_COLLECTION_NAME);
            MongoCollection collection = database.getCollection(MONGO_DB_COLLECTION_NAME);
            collection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"appId"}), Indexes.ascending((String[])new String[]{"instanceName"})}));
        }
        return database.getCollection(MONGO_DB_COLLECTION_NAME);
    }

    private String parseGroupName(String instanceName) {
        String groupName = "a";
        String[] instanceNameSplitByDash = instanceName.split("-");
        if (instanceNameSplitByDash.length == 5) {
            groupName = instanceNameSplitByDash[2];
        }
        return groupName;
    }

    private class ServiceInstanceThread
    extends Thread {
        ServiceInstanceService serviceInstanceService;

        public ServiceInstanceThread(ServiceInstanceService serviceInstanceService2, String threadName) {
            super(threadName);
            this.serviceInstanceService = serviceInstanceService2;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(ServiceInstanceService.this.reportFrequency);
                        this.serviceInstanceService.report();
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.error("ServiceInstanceService report exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

