/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.eai.DigiSrvcode;
import com.digiwin.app.log.CompressUtil;
import com.digiwin.app.log.JsonUtil;
import com.digiwin.app.log.dto.DapLogDto;
import com.digiwin.app.log.dto.DapRequest;
import com.digiwin.app.log.dto.DapService;
import com.digiwin.app.log.dto.LogItem;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.gateway.fuse.exception.DWServerErrorException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class DapLogUtils {
    public static final String TYPE_CB_SERVICE_PROVIDER_REQUEST = "request";
    public static final String TYPE_CB_SERVICE_PROVIDER_RESPONSE_RECEIVED_NONE_200 = "noneHttpStatus200";
    public static final String TYPE_CB_INVOKER_RESPONSE = "response";

    public static DapLogDto getDapCallbackLog(String logType, Object invokeResult, Map<String, Object> requestHeader) {
        return DapLogUtils.getDapCallbackLog(logType, invokeResult, requestHeader, null);
    }

    public static DapLogDto getDapCallbackLog(String logType, Object invokeResult, Map<String, Object> requestHeader, Exception exInInvocation) {
        boolean hasException;
        if (logType == null) {
            logType = TYPE_CB_SERVICE_PROVIDER_REQUEST;
        }
        DapLogDto dapLogDto = new DapLogDto();
        String logUrl = requestHeader.getOrDefault("digi-callback-logurl", "").toString();
        dapLogDto.setReq_id(requestHeader.getOrDefault("digi-reqid", UUID.randomUUID().toString()).toString());
        dapLogDto.setLogUrl(logUrl);
        Map<String, Object> digiserviceMap = JsonUtil.fromJsonMap(requestHeader.getOrDefault("digi-service", "").toString());
        Map<String, Object> digihostMap = JsonUtil.fromJsonMap(requestHeader.getOrDefault("digi-host", "").toString());
        String targetUrl = requestHeader.getOrDefault("digi-callback-url", "").toString();
        DapRequest request = new DapRequest();
        request.setAp_name(DapLogUtils.getSafeMapKey(digihostMap, "prod"));
        request.setVersion(DapLogUtils.getSafeMapKey(digihostMap, "ver"));
        request.setId("");
        request.setUid("");
        request.setAp_user(DapLogUtils.getSafeMapKey(digihostMap, "tenant_id"));
        request.setTimestamp(String.valueOf(System.currentTimeMillis()));
        dapLogDto.setRequest(request);
        DapService service = new DapService();
        service.setAp_name(DapLogUtils.getSafeMapKey(digiserviceMap, "prod"));
        service.setVersion("");
        service.setIp(requestHeader.getOrDefault("host", "").toString());
        service.setUid("");
        service.setId("");
        service.setTenant_id(DapLogUtils.getSafeMapKey(digiserviceMap, "tenant_id"));
        service.setService_name(requestHeader.getOrDefault("digi-callback-callback", "").toString());
        dapLogDto.setService(service);
        LogItem logItem = new LogItem();
        Map<String, String> logHeaderMap = null;
        String priority = "";
        String body = null;
        String stateCode = null;
        boolean bl = hasException = exInInvocation != null && TYPE_CB_SERVICE_PROVIDER_REQUEST.equals(logType);
        if (hasException) {
            if (exInInvocation instanceof DWServerErrorException) {
                DWServerErrorException serverErrorException = (DWServerErrorException)exInInvocation;
                body = serverErrorException.getResponseBody();
                stateCode = serverErrorException.getResponseStatusCode() == 504 ? "322" : "311";
            } else {
                body = DapLogUtils.getExceptionBodyString(exInInvocation);
                stateCode = "311";
            }
            priority = "4";
        } else {
            DWEAIResult eaiResult = null;
            boolean srvCodeIsSuccess = false;
            if (invokeResult instanceof DWEAIResult) {
                eaiResult = (DWEAIResult)invokeResult;
                srvCodeIsSuccess = eaiResult.getDigiSrvcodeOrDefault(DigiSrvcode.success) == DigiSrvcode.success;
                body = JsonUtil.toString(eaiResult.getDWEAIResult());
            } else {
                body = JsonUtil.toString(invokeResult);
            }
            if (TYPE_CB_SERVICE_PROVIDER_REQUEST.equals(logType)) {
                priority = "3";
                stateCode = srvCodeIsSuccess ? "0EA" : "0EB";
            } else if (TYPE_CB_SERVICE_PROVIDER_RESPONSE_RECEIVED_NONE_200.equals(logType)) {
                priority = "4";
                stateCode = "322";
                if (invokeResult instanceof DapLogCallbackResponseExtraInfo) {
                    DapLogCallbackResponseExtraInfo extraInfo = (DapLogCallbackResponseExtraInfo)invokeResult;
                    body = extraInfo.getBody();
                    logHeaderMap = new HashMap<String, String>(extraInfo.getHeaders());
                }
            } else {
                priority = "4";
                stateCode = "0EG";
            }
        }
        if (logHeaderMap == null) {
            logHeaderMap = requestHeader.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                if (null == entry.getValue()) {
                    return "";
                }
                return entry.getValue().toString();
            }, (o1, o2) -> o2));
        }
        logItem = DapLogUtils.createLogItem(stateCode, priority, targetUrl, logHeaderMap, body);
        dapLogDto.setLogs(new LogItem[]{logItem});
        return dapLogDto;
    }

    private static String getExceptionBodyString(Exception e) {
        Throwable rootCause;
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        if (stackTrace.length() > 50000) {
            stackTrace = stackTrace.substring(0, 50000);
        }
        for (rootCause = e; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(System.lineSeparator()).append("\"error\" : ").append(rootCause.getMessage()).append(System.lineSeparator()).append("\"catchError\" : ").append(e.getMessage()).append(System.lineSeparator()).append("\"stackTrace\" : ").append(stackTrace).append(System.lineSeparator()).append("}");
        return sb.toString();
    }

    public static LogItem createLogItem(String stateCode, String priority, String targetUrl, Map<String, String> headers, String bodyString) {
        LogItem logItem = new LogItem();
        logItem.setState_code(stateCode);
        logItem.setPlatform_time(String.valueOf(System.currentTimeMillis()));
        logItem.setLog_display_priority(priority);
        logItem.setUrl(targetUrl);
        logItem.setHeaders(headers);
        logItem.setData_key("");
        logItem.setBody(CompressUtil.compress(bodyString));
        return logItem;
    }

    public static String getSafeMapKey(Map<String, Object> stringObjectMap, String key) {
        return DapLogUtils.getSafeMapKey(stringObjectMap, key, "");
    }

    public static String getSafeMapKey(Map<String, Object> stringObjectMap, String key, String defaultValue) {
        if (null == stringObjectMap) {
            return defaultValue;
        }
        Object object = stringObjectMap.get(key);
        if (object != null) {
            return object.toString();
        }
        return defaultValue;
    }

    public static class DapLogCallbackResponseExtraInfo {
        private int statusCode;
        private Map<String, String> headers;
        private String body;

        public DapLogCallbackResponseExtraInfo(int statusCode, Map<String, String> headers, String body) {
            this.statusCode = statusCode;
            this.headers = headers;
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }
    }
}

