/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.alarm;

import com.digiwin.app.commons.eai.alarm.EAICallbackDelayed;
import com.digiwin.app.commons.eai.alarm.EaiAlarmApplicationEvent;
import com.digiwin.app.service.alarm.EaiCallbackArarmService;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class DefaultEaiCallbackAlarmService
implements EaiCallbackArarmService,
ApplicationContextAware {
    private static final ExecutorService FASYNC_ARLARM_EXECUTOR = Executors.newSingleThreadExecutor();
    private static final DelayQueue<EAICallbackDelayed> CALLBACK_DELAYDQUEUE = new DelayQueue();
    private ApplicationContext applicationContext;
    Predicate<EAICallbackDelayed> alarmPredicate;
    @Value(value="${dwMetrics.eaiCallBack.alarm.enable:false}")
    private boolean alarmEnable;
    private boolean running = false;
    @Value(value="${dwMetrics.eaiCallBack.alarm.queued.request.size:2000}")
    private int queuedSize;

    @Override
    public boolean dealEaiCallbackTimeOut(EAICallbackDelayed eaiCallbackDelayed) {
        if (!this.alarmEnable) {
            return false;
        }
        if (CALLBACK_DELAYDQUEUE.size() > this.queuedSize) {
            return false;
        }
        return CALLBACK_DELAYDQUEUE.offer(eaiCallbackDelayed, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean needAlarm(EAICallbackDelayed eaiCallbackDelayed) {
        return this.alarmEnable & this.alarmPredicate.test(eaiCallbackDelayed);
    }

    @Override
    public boolean ackCallBack(EAICallbackDelayed eaiCallbackDelayed) {
        if (!this.alarmEnable) {
            return false;
        }
        return CALLBACK_DELAYDQUEUE.remove(eaiCallbackDelayed);
    }

    public boolean startArarm(Predicate alarmPredicate) {
        if (!this.alarmEnable) {
            return false;
        }
        if (null == alarmPredicate) {
            throw new IllegalArgumentException("alarmPredicate must not be null");
        }
        if (this.running) {
            return false;
        }
        this.running = true;
        this.alarmPredicate = alarmPredicate;
        FASYNC_ARLARM_EXECUTOR.submit(() -> {
            while (true) {
                EAICallbackDelayed eaiCallbackDelayed;
                if (!this.needAlarm(eaiCallbackDelayed = (EAICallbackDelayed)CALLBACK_DELAYDQUEUE.take())) {
                    continue;
                }
                this.applicationContext.publishEvent((ApplicationEvent)new EaiAlarmApplicationEvent(eaiCallbackDelayed));
            }
        });
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

