/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.gateway.event.DWEvent;
import com.digiwin.gateway.event.DWEventContext;
import com.digiwin.gateway.event.DWEventListener;
import com.digiwin.gateway.event.DWEventProcessResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public abstract class DWAbstractEventContext
implements DWEventContext {
    private static Log log = LogFactory.getLog(DWAbstractEventContext.class);

    @Override
    public final <E extends DWEvent> List<DWEventProcessResult<E>> publishEvent(E event) {
        Objects.requireNonNull(event);
        List<DWEventListener<E>> listenerList = this.getEventListeners(event);
        this.sortEventListener(listenerList);
        ArrayList<DWEventProcessResult<DWEventProcessResult<E>>> resultList = new ArrayList<DWEventProcessResult<DWEventProcessResult<E>>>();
        for (DWEventListener<E> listener : listenerList) {
            DWEventProcessResult<E> result;
            try {
                result = listener.onEvent(event);
                if (result == null) {
                    result = new DWEventProcessResult<E>(event);
                }
                result.setListenerClassName(listener.getClass().getName());
                resultList.add(result);
            }
            catch (Exception e) {
                log.error((Object)(event.getClass().getName() + ".onInitialize exception occured!"), (Throwable)e);
                result = new DWEventProcessResult<E>(event, e);
                result.setListenerClassName(listener.getClass().getName());
                resultList.add(result);
            }
        }
        return resultList;
    }

    protected abstract <E extends DWEvent> List<DWEventListener<E>> getEventListeners(E var1);

    protected final <E extends DWEvent> List<DWEventListener<E>> getEventListeners(ApplicationContext applicationContext, E event) {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(DWEventListener.class, (Class[])new Class[]{event.getClass()});
        String[] listenerNameMap = applicationContext.getBeanNamesForType(resolvableType);
        List<DWEventListener<E>> listenerList = Arrays.stream(listenerNameMap).map(s -> (DWEventListener)applicationContext.getBean(s)).collect(Collectors.toList());
        return listenerList;
    }

    protected <E extends DWEvent> void sortEventListener(List<DWEventListener<E>> eventListenerList) {
        Collections.sort(eventListenerList, AnnotationAwareOrderComparator.INSTANCE);
    }
}

