/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.gateway.event.DWScheduleEvent;
import com.digiwin.gateway.event.DWScheduleEventConfig;

public class DWScheduleEventResult {
    private boolean success;
    private String message;
    private Object data;
    private Integer order;
    private transient Exception exception;
    private String eventName;
    private transient DWScheduleEvent sourceEvent;

    public DWScheduleEventResult(DWScheduleEvent sourceEvent, boolean success, String message, Object data) {
        this.sourceEvent = sourceEvent;
        this.eventName = sourceEvent == null ? "Unknown!" : sourceEvent.getClass().getName();
        this.success = success;
        this.data = data;
        this.message = message;
        this.order = DWScheduleEventConfig.getOrder(sourceEvent);
    }

    public DWScheduleEventResult(DWScheduleEvent sourceEvent, Exception initException) {
        this.sourceEvent = sourceEvent;
        this.eventName = sourceEvent == null ? "Unknown!" : sourceEvent.getClass().getName();
        this.success = false;
        this.data = null;
        this.message = initException == null ? null : initException.getMessage();
        this.exception = initException;
        this.order = DWScheduleEventConfig.getOrder(sourceEvent);
    }

    public DWScheduleEvent getSourceEvent() {
        return this.sourceEvent;
    }

    public String getEventName() {
        return this.eventName;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Integer getOrder() {
        return this.order;
    }
}

