/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.apollo;

import com.digiwin.app.common.config.remote.listener.DWConfigFileChangeEvent;
import com.digiwin.app.common.config.remote.listener.DWConfigFileChangeListener;
import com.digiwin.app.log.DWLog4jConfigurationSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Reconfigurable;

public class DWApolloLog4jFileWatcher
implements DWConfigFileChangeListener {
    private static Log log = LogFactory.getLog(DWApolloLog4jFileWatcher.class);

    public void fireLog4j2XMLOnChange() {
        LoggerContext loggerContextImpl = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContextImpl.getConfiguration();
        if (configuration instanceof Reconfigurable) {
            loggerContextImpl.onChange((Reconfigurable)configuration);
        } else {
            log.warn((Object)"Log4j LoggerContext configuration does not support reconfiguration on change event! You can contact DAP for further information.");
        }
    }

    public boolean updateConfigurationSource(String configurationSourceString) {
        try {
            LoggerContext loggerContextImpl = (LoggerContext)LogManager.getContext((boolean)false);
            ConfigurationSource configurationSource = loggerContextImpl.getConfiguration().getConfigurationSource();
            if (configurationSource instanceof DWLog4jConfigurationSource) {
                ((DWLog4jConfigurationSource)configurationSource).setLog4jXmlContent(configurationSourceString);
            }
            this.fireLog4j2XMLOnChange();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"log4j update failed, stack trace = ", (Throwable)e);
            return false;
        }
    }

    public void onChange(DWConfigFileChangeEvent event) {
        log.info((Object)"apollo log4j2.xml changed, use new method to update log4j2 context configuration");
        String newValue = event.getNewValue();
        String oldValue = event.getOldValue();
        if (this.updateConfigurationSource(newValue)) {
            return;
        }
        log.error((Object)"rollback log4j setting!!");
        if (this.updateConfigurationSource(oldValue)) {
            return;
        }
        log.error((Object)"rollback log4j failed");
    }
}

