/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.spring;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.config.remote.listener.DWConfigFileChangeListener;
import com.digiwin.app.common.config.remote.listener.ListenerRegister;
import com.digiwin.app.log.apollo.DWApolloLog4jFileWatcher;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.context.ApplicationEvent;

public class DWLoggingApplicationListener
extends LoggingApplicationListener {
    private static DWApolloLog4jFileWatcher apolloLog4jFileWatcher = null;

    public int getOrder() {
        return super.getOrder() + 1;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartingEvent) {
            this.onApplicationStartingEvent((ApplicationStartingEvent)event);
        } else if (event instanceof ApplicationEnvironmentPreparedEvent) {
            apolloLog4jFileWatcher.fireLog4j2XMLOnChange();
        }
    }

    private void onApplicationStartingEvent(ApplicationStartingEvent event) {
        if (apolloLog4jFileWatcher == null) {
            String logFileIdentifierValue = DWApplicationConfigUtils.getProperty((String)"logFileIdentifier", (String)"");
            if ("@logFileIdentifier@".equalsIgnoreCase(logFileIdentifierValue)) {
                logFileIdentifierValue = "";
            }
            Interpolator lookup = new Interpolator();
            StrSubstitutor replacer = new StrSubstitutor((StrLookup)lookup);
            String identifier = replacer.replace(logFileIdentifierValue);
            System.setProperty("logFileIdentifier", identifier);
            apolloLog4jFileWatcher = new DWApolloLog4jFileWatcher();
            apolloLog4jFileWatcher.fireLog4j2XMLOnChange();
            ListenerRegister.addLog4j2XmlChangeListener((DWConfigFileChangeListener)apolloLog4jFileWatcher);
        }
    }
}

