/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.common.config.ConfigPool;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.core.config.ConfigurationSource;

public class DWLog4jConfigurationSource
extends ConfigurationSource {
    private static final String DEFAULT_LOG_FILE_RESERVED_DAY = "7d";
    private static final String DEFAULT_LOG_LEVEL = "INFO";
    private String log4j2XmlContent = null;

    public DWLog4jConfigurationSource(InputStream stream) throws IOException {
        super(DWLog4jConfigurationSource.generatePlaceHolderReplacedContetInputStream(stream));
    }

    public DWLog4jConfigurationSource(InputStream stream, File file) {
        super(DWLog4jConfigurationSource.generatePlaceHolderReplacedContetInputStream(stream), file);
    }

    public DWLog4jConfigurationSource(InputStream stream, URL url) {
        super(DWLog4jConfigurationSource.generatePlaceHolderReplacedContetInputStream(stream), url);
    }

    public String getLatestLog4j2XmlContent() {
        ConfigPool pool = ConfigPool.getInstance();
        String xml = pool.getLog4j2Xml();
        return xml;
    }

    public void setLog4jXmlContent(String log4j2XmlContent) {
        this.log4j2XmlContent = log4j2XmlContent;
    }

    private String getLog4jXmlContent() {
        if (this.log4j2XmlContent == null) {
            this.log4j2XmlContent = this.getLatestLog4j2XmlContent();
        }
        this.log4j2XmlContent = DWLog4jConfigurationSource.replacePlaceHolder(this.log4j2XmlContent);
        return this.log4j2XmlContent;
    }

    public ConfigurationSource resetInputStream() throws IOException {
        String xml = this.getLog4jXmlContent();
        byte[] byteArray = xml.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DWLog4jConfigurationSource dapConfigurationSource = new DWLog4jConfigurationSource(bufferedInputStream);
        return dapConfigurationSource;
    }

    private static String replacePlaceHolder(String sourceContent) {
        if (sourceContent == null) {
            return null;
        }
        if (sourceContent.contains("@logFileReservedDay@")) {
            sourceContent = sourceContent.replace("@logFileReservedDay@", DEFAULT_LOG_FILE_RESERVED_DAY);
            System.out.println(String.format("Warning! using default logFileReservedDay (%s), please check config center or platform/conf/log4j2.xml", DEFAULT_LOG_FILE_RESERVED_DAY));
        }
        if (sourceContent.contains("@logLevel@")) {
            sourceContent = sourceContent.replace("@logLevel@", DEFAULT_LOG_LEVEL);
            System.out.println(String.format("Warning! using default logLevel (%s), please check config center or platform/conf/log4j2.xml", DEFAULT_LOG_LEVEL));
        }
        return sourceContent;
    }

    private static InputStream generatePlaceHolderReplacedContetInputStream(InputStream sourceInputStream) {
        String content = "";
        try {
            content = IOUtils.toString((InputStream)sourceInputStream, (Charset)StandardCharsets.UTF_8);
            content = DWLog4jConfigurationSource.replacePlaceHolder(content);
            if (content == null) {
                content = "";
            }
            return IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

