/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.commons.eai.alarm;

import com.digiwin.app.commons.eai.alarm.EAICallBackType;
import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class EAICallbackDelayed
implements Delayed {
    private final String reqId;
    private final long delayTime;
    private final String requestApp;
    private final String targetApp;
    private final EAICallBackType type;
    private final String api;
    private final String tenantId;
    public static final long DEFAULT_DELAY = 1800000L;

    public EAICallbackDelayed(String reqId, String requestApp, String targetApp, EAICallBackType type, String api, String tenantId) {
        this.reqId = reqId;
        this.delayTime = System.currentTimeMillis() + 1800000L;
        this.requestApp = requestApp;
        this.targetApp = targetApp;
        this.type = type;
        this.api = api;
        this.tenantId = tenantId;
    }

    public EAICallbackDelayed(String reqId, String requestApp, String targetApp, String api, String tenantId) {
        this.reqId = reqId;
        this.delayTime = System.currentTimeMillis() + 1800000L;
        this.requestApp = requestApp;
        this.targetApp = targetApp;
        this.type = EAICallBackType.FASYNC;
        this.api = api;
        this.tenantId = tenantId;
    }

    public EAICallbackDelayed(String reqId) {
        this.reqId = reqId;
        this.delayTime = System.currentTimeMillis() + 1800000L;
        this.requestApp = null;
        this.targetApp = null;
        this.type = EAICallBackType.FASYNC;
        this.api = null;
        this.tenantId = null;
    }

    public EAICallbackDelayed(String reqId, long delay, String requestApp, String targetApp, EAICallBackType type, String api, String tenantId) {
        this.reqId = reqId;
        this.delayTime = System.currentTimeMillis() + delay;
        this.requestApp = requestApp;
        this.targetApp = targetApp;
        this.type = type;
        this.api = api;
        this.tenantId = tenantId;
    }

    public EAICallBackType getType() {
        return this.type;
    }

    public String getReqId() {
        return this.reqId;
    }

    public String getRequestApp() {
        return this.requestApp;
    }

    public String getTargetApp() {
        return this.targetApp;
    }

    public String getApi() {
        return this.api;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delayTime - System.currentTimeMillis() > 0L ? this.delayTime - System.currentTimeMillis() : 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o instanceof EAICallbackDelayed) {
            return (int)(this.getDelayTime() - ((EAICallbackDelayed)o).getDelayTime());
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EAICallbackDelayed that = (EAICallbackDelayed)o;
        return Objects.equals(this.reqId, that.reqId);
    }

    public int hashCode() {
        return Objects.hash(this.reqId);
    }

    public String toString() {
        return "EAICallbackDelayed{reqId='" + this.reqId + '\'' + ", delayTime=" + this.delayTime + ", requestApp='" + this.requestApp + '\'' + ", targetApp='" + this.targetApp + '\'' + ", type=" + (Object)((Object)this.type) + ", api='" + this.api + '\'' + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

