/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.gateway.event.DWEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;

public class DWEventProcessResult<E extends DWEvent> {
    private transient E event;
    private String eventClassName;
    private String listenerClassName;
    private boolean success = true;
    private String message;
    private String errorStackTrace;

    public DWEventProcessResult(E event) {
        this(event, null);
    }

    public DWEventProcessResult(E event, Exception e) {
        Objects.requireNonNull(event);
        this.event = event;
        this.eventClassName = event.getClass().getName();
        if (e != null) {
            this.buildExStackTrace(e);
        }
    }

    private void buildExStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        this.errorStackTrace = stringWriter.toString();
        this.message = e.getMessage();
        this.success = false;
    }

    public E getEvent() {
        return this.event;
    }

    protected void setListenerClassName(String listenerClassName) {
        this.listenerClassName = listenerClassName;
    }

    public String getEventClassName() {
        return this.eventClassName;
    }

    public String getListenerClassName() {
        return this.listenerClassName;
    }

    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

